/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public class KeyStoreBackedSecurityRealm
implements SecurityRealm {
    private final KeyStore keyStore;

    public KeyStoreBackedSecurityRealm(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        return new KeyStoreRealmIdentity(name);
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType) {
        return credentialType.isAssignableFrom(SecretKey.class) || credentialType.isAssignableFrom(Password.class) || credentialType.isAssignableFrom(X500PrivateCredential.class) ? CredentialSupport.UNKNOWN : CredentialSupport.UNSUPPORTED;
    }

    private KeyStore.Entry getEntry(String name) {
        try {
            return this.keyStore.getEntry(name, null);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnrecoverableEntryException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    private class KeyStoreRealmIdentity
    implements RealmIdentity {
        private final String name;

        private KeyStoreRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credentialType.isInstance(password)) {
                    return CredentialSupport.FULLY_SUPPORTED;
                }
                return CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = privateKeyEntry.getCertificate();
                return credentialType.isInstance(privateKey) || credentialType.isInstance(certificate) || certificate instanceof X509Certificate && X500PrivateCredential.class.isAssignableFrom(credentialType) ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                return credentialType.isInstance(((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate()) ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof KeyStore.SecretKeyEntry) {
                return credentialType.isInstance(((KeyStore.SecretKeyEntry)entry).getSecretKey()) ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
            }
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) {
            SecretKey secretKey;
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return null;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credentialType.isInstance(password)) {
                    return credentialType.cast(password);
                }
            } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = privateKeyEntry.getCertificate();
                if (credentialType.isInstance(privateKey)) {
                    return credentialType.cast(privateKey);
                }
                if (credentialType.isInstance(certificate)) {
                    return credentialType.cast(certificate);
                }
                if (credentialType.isAssignableFrom(X500PrivateCredential.class) && certificate instanceof X509Certificate) {
                    return credentialType.cast(new X500PrivateCredential((X509Certificate)certificate, privateKey, this.name));
                }
            } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
                Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
                if (credentialType.isInstance(certificate)) {
                    return credentialType.cast(certificate);
                }
            } else if (entry instanceof KeyStore.SecretKeyEntry && credentialType.isInstance(secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey())) {
                return credentialType.cast(secretKey);
            }
            return null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            return new AuthorizationIdentity(){};
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return false;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credential instanceof char[]) {
                    try {
                        return PasswordFactory.getInstance(password.getAlgorithm()).verify(password, (char[])credential);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new RealmUnavailableException(e);
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }
    }
}

