/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.jdbc.mapper;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.ResultSet;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.jdbc.KeyMapper;
import org.wildfly.security.auth.server.CredentialSupport;

public class RSAPrivateKeyMapper
implements KeyMapper {
    private static final String KEY_ALGORITHM = "RSA";
    private final int privateKey;

    public RSAPrivateKeyMapper(int privateKey) {
        Assert.checkMinimumParameter((String)"privateKey", (int)1, (int)privateKey);
        this.privateKey = privateKey;
    }

    public int getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Class<?> getKeyType() {
        return PrivateKey.class;
    }

    @Override
    public CredentialSupport getCredentialSupport(ResultSet resultSet) {
        Object map = this.map(resultSet);
        if (map != null) {
            return CredentialSupport.OBTAINABLE_ONLY;
        }
        return CredentialSupport.UNSUPPORTED;
    }

    @Override
    public Object map(ResultSet resultSet) {
        Object privateKey = null;
        try {
            if (resultSet.next()) {
                privateKey = resultSet.getObject(this.getPrivateKey());
            }
        }
        catch (Exception e) {
            throw ElytronMessages.log.couldNotGetRsaKeyFromQuery(e);
        }
        if (privateKey != null) {
            try {
                KeyFactory kf = KeyFactory.getInstance(KEY_ALGORITHM);
                return kf.generatePrivate(new PKCS8EncodedKeySpec((byte[])privateKey));
            }
            catch (NoSuchAlgorithmException e) {
                throw ElytronMessages.log.invalidAlgorithm(KEY_ALGORITHM, e);
            }
            catch (InvalidKeySpecException e) {
                throw ElytronMessages.log.couldNotParsePrivateKey(e);
            }
        }
        return null;
    }
}

