/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.provider.ldap.UserPasswordPasswordUtil;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.BSDUnixDESCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.interfaces.UnixDESCryptPassword;

class UserPasswordCredentialLoader
implements CredentialLoader {
    static final String DEFAULT_USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    static Map<Class<?>, CredentialSupport> DEFAULT_CREDENTIAL_SUPPORT = new HashMap();
    private final String userPasswordAttributeName;

    public UserPasswordCredentialLoader(String userPasswordAttributeName) {
        this.userPasswordAttributeName = userPasswordAttributeName;
    }

    @Override
    public CredentialSupport getCredentialSupport(DirContextFactory contextFactory, Class<?> credentialType) {
        CredentialSupport response = DEFAULT_CREDENTIAL_SUPPORT.get(credentialType);
        if (response == null) {
            response = CredentialSupport.UNSUPPORTED;
        }
        return response;
    }

    @Override
    public IdentityCredentialLoader forIdentity(DirContextFactory contextFactory, String distinguishedName) {
        return new ForIdentityLoader(contextFactory, distinguishedName);
    }

    static {
        DEFAULT_CREDENTIAL_SUPPORT.put(ClearPassword.class, CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put(SimpleDigestPassword.class, CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put(SaltedSimpleDigestPassword.class, CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put(BSDUnixDESCryptPassword.class, CredentialSupport.UNKNOWN);
        DEFAULT_CREDENTIAL_SUPPORT.put(UnixDESCryptPassword.class, CredentialSupport.UNKNOWN);
    }

    private class ForIdentityLoader
    implements IdentityCredentialLoader {
        private final DirContextFactory contextFactory;
        private final String distinguishedName;

        public ForIdentityLoader(DirContextFactory contextFactory, String distinguishedName) {
            this.contextFactory = contextFactory;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) {
            Object credential = this.getCredential(credentialType);
            if (credential != null && credentialType.isInstance(credential)) {
                return CredentialSupport.FULLY_SUPPORTED;
            }
            return CredentialSupport.UNSUPPORTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C> C getCredential(Class<C> credentialType) {
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{UserPasswordCredentialLoader.this.userPasswordAttributeName});
                Attribute attribute = attributes.get(UserPasswordCredentialLoader.this.userPasswordAttributeName);
                for (int i = 0; i < attribute.size(); ++i) {
                    byte[] value = (byte[])attribute.get(i);
                    Password password = UserPasswordPasswordUtil.parseUserPassword(value);
                    if (!credentialType.isInstance(password)) continue;
                    C c = credentialType.cast(password);
                    return c;
                }
                C c = null;
                return c;
            }
            catch (InvalidKeySpecException | NamingException e) {
                C c = null;
                return c;
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }
    }
}

