/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialParameterCallback;
import org.wildfly.security.auth.callback.CredentialVerifyCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.callback.PasswordVerifyCallback;
import org.wildfly.security.auth.callback.PeerPrincipalCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.callback.SocketAddressCallback;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.AuthenticationCompleteCallbackSaslServerFactory;

public final class ServerAuthenticationContext {
    private static final Map<String, String> QUERY_ALL = Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true");
    private final SecurityDomain domain;
    private final AtomicReference<State> stateRef = new AtomicReference<SimpleState>(INITIAL);
    private static final int INITIAL_ID = 0;
    private static final int IN_PROGRESS_ID = 1;
    private static final int FAILED_ID = 2;
    private static final int ASSIGNED_ID = 3;
    private static final int COMPLETE_ID = 4;
    private static final SimpleState INITIAL = new SimpleState(0, false, false);
    private static final SimpleState IN_PROGRESS = new SimpleState(1, false, true);
    private static final SimpleState FAILED = new SimpleState(2, true, true);

    ServerAuthenticationContext(SecurityDomain domain) {
        this.domain = domain;
    }

    public SaslServer createSaslServer(SaslServerFactory saslServerFactory, String serverName, String mechanismName, String protocol) throws SaslException, IllegalStateException {
        Assert.checkNotNullParam((String)"saslServerFactory", (Object)saslServerFactory);
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        Assert.checkNotNullParam((String)"protocol", (Object)protocol);
        AuthenticationCompleteCallbackSaslServerFactory factory = new AuthenticationCompleteCallbackSaslServerFactory(saslServerFactory);
        CallbackHandler callbackHandler = mechanismName.equals("ANONYMOUS") ? this.createAnonymousCallbackHandler() : this.createCallbackHandler();
        return factory.createSaslServer(mechanismName, protocol, serverName, QUERY_ALL, callbackHandler);
    }

    public SSLEngine createServerSslEngine() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public SSLSocket createServerSslSocket() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        return this.stateRef.get().getAuthorizedIdentity();
    }

    public void anonymous() throws IllegalStateException {
        State oldState = this.stateRef.get();
        if (oldState.isDone()) {
            throw ElytronMessages.log.alreadyComplete();
        }
        CompleteState completeState = new CompleteState(this.domain.getAnonymousSecurityIdentity());
        while (!this.stateRef.compareAndSet(oldState, completeState)) {
            oldState = this.stateRef.get();
            if (!oldState.isDone()) continue;
            throw ElytronMessages.log.alreadyComplete();
        }
        if (oldState.getId() == 3) {
            oldState.getRealmIdentity().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        State oldState;
        Assert.checkNotNullParam((String)"name", (Object)name);
        do {
            if (!(oldState = this.stateRef.get()).isDone()) continue;
            throw ElytronMessages.log.alreadyComplete();
        } while (!this.stateRef.compareAndSet(oldState, IN_PROGRESS));
        boolean ok = false;
        try {
            name = this.domain.getPreRealmRewriter().rewriteName(name);
            if (name == null) {
                throw ElytronMessages.log.invalidName();
            }
            String realmName = this.domain.mapRealmName(name);
            NamePrincipal principal = new NamePrincipal(name);
            RealmInfo realmInfo = this.domain.getRealmInfo(realmName);
            name = this.domain.getPostRealmRewriter().rewriteName(name);
            if (name == null) {
                throw ElytronMessages.log.invalidName();
            }
            name = realmInfo.getNameRewriter().rewriteName(name);
            if (name == null) {
                throw ElytronMessages.log.invalidName();
            }
            SecurityRealm securityRealm = realmInfo.getSecurityRealm();
            RealmIdentity realmIdentity = securityRealm.createRealmIdentity(name);
            try {
                if (!this.stateRef.compareAndSet(IN_PROGRESS, new NameAssignedState(principal, realmInfo, realmIdentity))) {
                    throw Assert.unreachableCode();
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    realmIdentity.dispose();
                }
            }
        }
        finally {
            if (!ok) {
                this.stateRef.compareAndSet(IN_PROGRESS, oldState);
            }
        }
    }

    public void setAuthenticationPrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        String name = this.domain.getPrincipalDecoder().getName(principal);
        if (name == null) {
            throw ElytronMessages.log.unrecognizedPrincipalType(principal);
        }
        this.setAuthenticationName(name);
    }

    public boolean isSameName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        name = this.domain.getPreRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        String realmName = this.domain.mapRealmName(name);
        RealmInfo realmInfo = this.domain.getRealmInfo(realmName);
        name = this.domain.getPostRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        name = realmInfo.getNameRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        return this.stateRef.get().getAuthenticationPrincipal().getName().equals(name);
    }

    public boolean exists() throws RealmUnavailableException, IllegalStateException {
        return this.stateRef.get().getRealmIdentity().exists();
    }

    public boolean isSamePrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        String name = this.domain.getPrincipalDecoder().getName(principal);
        return name != null && this.isSameName(name);
    }

    public void fail() throws IllegalStateException {
        State oldState;
        do {
            if ((oldState = this.stateRef.get()).isDone()) {
                throw ElytronMessages.log.alreadyComplete();
            }
            if (oldState.isStarted()) continue;
            throw ElytronMessages.log.noAuthenticationInProgress();
        } while (!this.stateRef.compareAndSet(oldState, FAILED));
        if (oldState.getId() == 3) {
            oldState.getRealmIdentity().dispose();
        }
    }

    public boolean authorize(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        State oldState = this.stateRef.get();
        if (oldState.isDone()) {
            throw ElytronMessages.log.alreadyComplete();
        }
        if (!oldState.isStarted()) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }
        Assert.checkNotNullParam((String)"name", (Object)name);
        name = this.domain.getPreRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        String realmName = this.domain.mapRealmName(name);
        NamePrincipal principal = new NamePrincipal(name);
        if (oldState.getAuthenticationPrincipal().equals(principal)) {
            this.succeed();
            return true;
        }
        RealmInfo realmInfo = this.domain.getRealmInfo(realmName);
        name = this.domain.getPostRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        name = realmInfo.getNameRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        SecurityRealm securityRealm = realmInfo.getSecurityRealm();
        RealmIdentity realmIdentity = securityRealm.createRealmIdentity(name);
        AuthorizationIdentity authorizationIdentity = realmIdentity.getAuthorizationIdentity();
        SecurityIdentity securityIdentity = new SecurityIdentity(this.domain, principal, realmInfo, authorizationIdentity);
        if (securityIdentity.getPermissions().implies(new RunAsPrincipalPermission(name))) {
            CompleteState newState = new CompleteState(securityIdentity);
            while (!this.stateRef.compareAndSet(oldState, newState)) {
                oldState = this.stateRef.get();
                if (oldState.isDone()) {
                    throw ElytronMessages.log.alreadyComplete();
                }
                if (oldState.isStarted()) continue;
                throw ElytronMessages.log.noAuthenticationInProgress();
            }
            oldState.getRealmIdentity().dispose();
            return true;
        }
        this.fail();
        return false;
    }

    public void succeed() throws IllegalStateException, RealmUnavailableException {
        State oldState = this.stateRef.get();
        if (oldState.isDone()) {
            throw ElytronMessages.log.alreadyComplete();
        }
        if (!oldState.isStarted()) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }
        RealmInfo realmInfo = oldState.getRealmInfo();
        AuthorizationIdentity authorizationIdentity = oldState.getRealmIdentity().getAuthorizationIdentity();
        CompleteState newState = new CompleteState(new SecurityIdentity(this.domain, oldState.getAuthenticationPrincipal(), realmInfo, authorizationIdentity));
        while (!this.stateRef.compareAndSet(oldState, newState)) {
            oldState = this.stateRef.get();
            if (oldState.isDone()) {
                throw ElytronMessages.log.alreadyComplete();
            }
            if (oldState.isStarted()) continue;
            throw ElytronMessages.log.noAuthenticationInProgress();
        }
        oldState.getRealmIdentity().dispose();
    }

    public boolean isDone() {
        return this.stateRef.get().isDone();
    }

    public Principal getAuthenticationPrincipal() throws RealmUnavailableException {
        return this.stateRef.get().getAuthenticationPrincipal();
    }

    public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
        return this.stateRef.get().getCredentialSupport(credentialType);
    }

    public <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
        return this.stateRef.get().getCredential(credentialType);
    }

    public boolean verifyCredential(Object credential) throws RealmUnavailableException {
        return this.stateRef.get().verifyCredential(credential);
    }

    CallbackHandler createAnonymousCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                this.handleOne(callbacks, 0);
            }

            private void handleOne(Callback[] callbacks, int idx) throws IOException, UnsupportedCallbackException {
                if (idx == callbacks.length) {
                    return;
                }
                Callback callback = callbacks[idx];
                if (callback instanceof AnonymousAuthorizationCallback) {
                    ServerAuthenticationContext.this.anonymous();
                    ((AnonymousAuthorizationCallback)callback).setAuthorized(true);
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof AuthenticationCompleteCallback) {
                    if (!ServerAuthenticationContext.this.isDone()) {
                        if (((AuthenticationCompleteCallback)callback).succeeded()) {
                            ServerAuthenticationContext.this.succeed();
                        } else {
                            ServerAuthenticationContext.this.fail();
                        }
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof SocketAddressCallback) {
                    SocketAddressCallback socketAddressCallback = (SocketAddressCallback)callback;
                    if (socketAddressCallback.getKind() == SocketAddressCallback.Kind.PEER) {
                        // empty if block
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof SecurityIdentityCallback) {
                    ((SecurityIdentityCallback)callback).setSecurityIdentity(ServerAuthenticationContext.this.getAuthorizedIdentity());
                    this.handleOne(callbacks, idx + 1);
                } else {
                    CallbackUtil.unsupported(callback);
                }
            }
        };
    }

    CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                this.handleOne(callbacks, 0);
            }

            private void handleOne(Callback[] callbacks, int idx) throws IOException, UnsupportedCallbackException {
                if (idx == callbacks.length) {
                    return;
                }
                Callback callback = callbacks[idx];
                if (callback instanceof AuthorizeCallback) {
                    AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                    String authorizationID = authorizeCallback.getAuthorizationID();
                    authorizeCallback.setAuthorized(ServerAuthenticationContext.this.authorize(authorizationID));
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof NameCallback) {
                    String name = ((NameCallback)callback).getDefaultName();
                    try {
                        ServerAuthenticationContext.this.setAuthenticationName(name);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof PeerPrincipalCallback) {
                    Principal principal = ((PeerPrincipalCallback)callback).getPrincipal();
                    try {
                        ServerAuthenticationContext.this.setAuthenticationPrincipal(principal);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof PasswordVerifyCallback) {
                    PasswordVerifyCallback passwordVerifyCallback = (PasswordVerifyCallback)callback;
                    char[] providedPassword = passwordVerifyCallback.getPassword();
                    if (ServerAuthenticationContext.this.getCredentialSupport(char[].class).isDefinitelyVerifiable()) {
                        passwordVerifyCallback.setVerified(ServerAuthenticationContext.this.verifyCredential(providedPassword));
                    } else if (ServerAuthenticationContext.this.getCredentialSupport(TwoWayPassword.class).isDefinitelyVerifiable()) {
                        try {
                            PasswordFactory passwordFactory = PasswordFactory.getInstance("clear");
                            Password password = passwordFactory.generatePassword(new ClearPasswordSpec(providedPassword));
                            passwordVerifyCallback.setVerified(ServerAuthenticationContext.this.verifyCredential(password));
                        }
                        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                            throw new FastUnsupportedCallbackException(callback);
                        }
                    } else {
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof PasswordCallback) {
                    ClearPasswordSpec clearPasswordSpec;
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    TwoWayPassword credential = ServerAuthenticationContext.this.getCredential(TwoWayPassword.class);
                    if (credential == null) {
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    try {
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(credential.getAlgorithm());
                        clearPasswordSpec = passwordFactory.getKeySpec(credential, ClearPasswordSpec.class);
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof CredentialCallback) {
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    for (Class<?> allowedType : credentialCallback.getAllowedTypes()) {
                        Object credential;
                        if (!ServerAuthenticationContext.this.getCredentialSupport(allowedType).mayBeObtainable() || (credential = ServerAuthenticationContext.this.getCredential(allowedType)) == null) continue;
                        credentialCallback.setCredential(credential);
                        break;
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof CredentialVerifyCallback) {
                    CredentialVerifyCallback credentialVerifyCallback = (CredentialVerifyCallback)callback;
                    Object credential = credentialVerifyCallback.getCredential();
                    if (ServerAuthenticationContext.this.getCredentialSupport(credential.getClass()).isDefinitelyVerifiable()) {
                        credentialVerifyCallback.setVerified(ServerAuthenticationContext.this.verifyCredential(credential));
                    }
                } else if (callback instanceof CredentialParameterCallback) {
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof AuthenticationCompleteCallback) {
                    if (!ServerAuthenticationContext.this.isDone()) {
                        if (((AuthenticationCompleteCallback)callback).succeeded()) {
                            ServerAuthenticationContext.this.succeed();
                        } else {
                            ServerAuthenticationContext.this.fail();
                        }
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof SocketAddressCallback) {
                    SocketAddressCallback socketAddressCallback = (SocketAddressCallback)callback;
                    if (socketAddressCallback.getKind() == SocketAddressCallback.Kind.PEER) {
                        // empty if block
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof SecurityIdentityCallback) {
                    ((SecurityIdentityCallback)callback).setSecurityIdentity(ServerAuthenticationContext.this.getAuthorizedIdentity());
                    this.handleOne(callbacks, idx + 1);
                } else {
                    CallbackUtil.unsupported(callback);
                }
            }
        };
    }

    static final class NameAssignedState
    extends State {
        private final Principal authenticationPrincipal;
        private final RealmInfo realmInfo;
        private final RealmIdentity realmIdentity;

        NameAssignedState(Principal authenticationPrincipal, RealmInfo realmInfo, RealmIdentity realmIdentity) {
            this.authenticationPrincipal = authenticationPrincipal;
            this.realmInfo = realmInfo;
            this.realmIdentity = realmIdentity;
        }

        @Override
        int getId() {
            return 3;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return this.authenticationPrincipal;
        }

        @Override
        CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
            return this.realmIdentity.getCredentialSupport(credentialType);
        }

        @Override
        <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.realmIdentity.getCredential(credentialType);
        }

        @Override
        boolean verifyCredential(Object credential) throws RealmUnavailableException {
            return this.realmIdentity.verifyCredential(credential);
        }

        @Override
        RealmInfo getRealmInfo() {
            return this.realmInfo;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return this.realmIdentity;
        }

        @Override
        boolean isDone() {
            return false;
        }

        @Override
        boolean isStarted() {
            return true;
        }
    }

    static final class CompleteState
    extends State {
        private final SecurityIdentity identity;

        public CompleteState(SecurityIdentity identity) {
            this.identity = identity;
        }

        @Override
        int getId() {
            return 4;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.identity;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        CredentialSupport getCredentialSupport(Class<?> credentialType) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        boolean verifyCredential(Object credential) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        RealmInfo getRealmInfo() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        RealmIdentity getRealmIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        boolean isDone() {
            return true;
        }

        @Override
        boolean isStarted() {
            return true;
        }
    }

    static final class SimpleState
    extends State {
        private final int id;
        private final boolean done;
        private final boolean started;

        SimpleState(int id, boolean done, boolean started) {
            this.id = id;
            this.done = done;
            this.started = started;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        Principal getAuthenticationPrincipal() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        CredentialSupport getCredentialSupport(Class<?> credentialType) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        boolean verifyCredential(Object credential) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        RealmInfo getRealmInfo() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        RealmIdentity getRealmIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        @Override
        boolean isDone() {
            return this.done;
        }

        @Override
        boolean isStarted() {
            return this.started;
        }
    }

    static abstract class State {
        State() {
        }

        abstract int getId();

        abstract SecurityIdentity getAuthorizedIdentity();

        abstract Principal getAuthenticationPrincipal();

        abstract CredentialSupport getCredentialSupport(Class<?> var1) throws RealmUnavailableException;

        abstract <C> C getCredential(Class<C> var1) throws RealmUnavailableException;

        abstract boolean verifyCredential(Object var1) throws RealmUnavailableException;

        abstract RealmInfo getRealmInfo();

        abstract RealmIdentity getRealmIdentity();

        abstract boolean isDone();

        abstract boolean isStarted();
    }
}

