/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClient;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class AuthenticationCompleteCallbackSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    public AuthenticationCompleteCallbackSaslClientFactory(SaslClientFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        SaslClient delegateSaslClient = this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        return delegateSaslClient == null ? null : new AbstractDelegatingSaslClient(delegateSaslClient){
            private final AtomicBoolean complete;
            {
                super(delegate);
                this.complete = new AtomicBoolean();
            }

            @Override
            public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
                try {
                    byte[] response = this.delegate.evaluateChallenge(challenge);
                    if (this.isComplete() && this.complete.compareAndSet(false, true)) {
                        try {
                            cbh.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED});
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return response;
                }
                catch (Error | RuntimeException | SaslException e) {
                    if (this.isComplete() && this.complete.compareAndSet(false, true)) {
                        try {
                            cbh.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }
        };
    }
}

