/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.IdentityHashMap;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.ssl.ConfiguredSSLContextSpi;
import org.wildfly.security.ssl.DelegatingSSLContext;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SNIServerSSLContextSelector;
import org.wildfly.security.ssl.SNIServerSSLEngine;
import org.wildfly.security.ssl.SSLConfigurator;

public final class SSLUtils {
    private static final String serviceType = SSLContext.class.getSimpleName();
    public static final String SSL_SESSION_IDENTITY_KEY = "org.wildfly.security.ssl.identity";
    private static final SecurityFactory<X509TrustManager> DEFAULT_TRUST_MANAGER_SECURITY_FACTORY = new OneTimeSecurityFactory<X509TrustManager>(() -> {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw ElytronMessages.log.noDefaultTrustManager();
    });

    private SSLUtils() {
    }

    public static SecurityFactory<SSLContext> createSslContextFactory(ProtocolSelector protocolSelector, Supplier<Provider[]> providerSupplier) {
        String[] supportedProtocols;
        Provider[] providers = providerSupplier.get();
        IdentityHashMap<String, Provider> preferredProviderByAlgorithm = new IdentityHashMap<String, Provider>();
        for (Provider provider : providers) {
            for (Provider.Service service : provider.getServices()) {
                String protocolName;
                if (!serviceType.equals(service.getType()) || preferredProviderByAlgorithm.containsKey(protocolName = service.getAlgorithm())) continue;
                preferredProviderByAlgorithm.put(protocolName, provider);
            }
        }
        for (String supportedProtocol : supportedProtocols = protocolSelector.evaluate(preferredProviderByAlgorithm.keySet().toArray(new String[preferredProviderByAlgorithm.size()]))) {
            Provider provider = (Provider)preferredProviderByAlgorithm.get(supportedProtocol);
            if (provider == null) continue;
            return SSLUtils.createSimpleSslContextFactory(supportedProtocol, provider);
        }
        return SSLUtils::throwIt;
    }

    private static SSLContext throwIt() throws NoSuchAlgorithmException {
        throw ElytronMessages.log.noAlgorithmForSslProtocol();
    }

    public static SecurityFactory<SSLContext> createSimpleSslContextFactory(String protocol, Provider provider) {
        return () -> SSLContext.getInstance(protocol, provider);
    }

    public static SSLContext createConfiguredSslContext(SSLContext original, SSLConfigurator sslConfigurator) {
        return new DelegatingSSLContext(new ConfiguredSSLContextSpi(original, sslConfigurator));
    }

    public static SecurityFactory<SSLContext> createConfiguredSslContextFactory(SecurityFactory<SSLContext> originalFactory, SSLConfigurator sslConfigurator) {
        return () -> SSLUtils.createConfiguredSslContext((SSLContext)originalFactory.create(), sslConfigurator);
    }

    public static SecurityFactory<X509TrustManager> getDefaultX509TrustManagerSecurityFactory() {
        return DEFAULT_TRUST_MANAGER_SECURITY_FACTORY;
    }

    public static SSLEngine createSNIDispatchingSSLEngine(SNIServerSSLContextSelector selector) {
        Assert.checkNotNullParam((String)"selector", (Object)selector);
        return new SNIServerSSLEngine(selector);
    }

    public static SecurityFactory<SSLEngine> createSNIDispatchingSSLEngineFactory(SNIServerSSLContextSelector selector) {
        Assert.checkNotNullParam((String)"selector", (Object)selector);
        return () -> new SNIServerSSLEngine(selector);
    }
}

