/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.levels.internal;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.picketlink.Identity;
import org.picketlink.annotations.PicketLink;
import org.picketlink.authentication.Authenticator;
import org.picketlink.authentication.levels.Level;
import org.picketlink.authentication.levels.SecurityLevelResolver;
import org.picketlink.authentication.levels.annotations.SecurityLevel;
import org.picketlink.common.exceptions.PicketLinkException;
import org.picketlink.producer.LevelFactoryResolver;

@PicketLink
public class AuthenticatorLevelResolver
implements SecurityLevelResolver {
    @Inject
    @PicketLink
    private Instance<Authenticator> authenticatorInstance;
    @Inject
    @Any
    private Identity identity;
    @Inject
    private LevelFactoryResolver levelFactoryResolver;

    protected String resolveLevel() {
        if (!this.identity.isLoggedIn()) {
            throw new PicketLinkException();
        }
        if (this.authenticatorInstance.isUnsatisfied()) {
            throw new PicketLinkException();
        }
        SecurityLevel a = ((Authenticator)this.authenticatorInstance.get()).getClass().getAnnotation(SecurityLevel.class);
        if (a == null) {
            throw new PicketLinkException();
        }
        return a.value();
    }

    public Level resolve() {
        try {
            String level = this.resolveLevel();
            return this.levelFactoryResolver.resolve().createLevel(level);
        }
        catch (PicketLinkException e) {
            return null;
        }
    }
}

