/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.modules.Module;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshalledValueMarshaller;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.marshalling.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.VersionedMarshallingConfiguration;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshallingContext;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionFactory;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class InfinispanSessionManagerFactory
implements SessionManagerFactory<TransactionBatch> {
    private final InfinispanSessionManagerFactoryConfiguration config;

    public InfinispanSessionManagerFactory(InfinispanSessionManagerFactoryConfiguration config) {
        this.config = config;
    }

    public <L> SessionManager<L, TransactionBatch> createSessionManager(final SessionContext context, IdentifierFactory<String> identifierFactory, LocalContextFactory<L> localContextFactory) {
        InfinispanBatcher batcher = new InfinispanBatcher(this.config.getCache());
        final Cache cache = this.config.getCache();
        final AffinityIdentifierFactory<String> factory = new AffinityIdentifierFactory<String>(identifierFactory, cache, this.config.getKeyAffinityServiceFactory());
        CommandDispatcherFactory dispatcherFactory = this.config.getCommandDispatcherFactory();
        NodeFactory<Address> nodeFactory = this.config.getNodeFactory();
        int maxActiveSessions = this.config.getSessionManagerConfiguration().getMaxActiveSessions();
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration((Batcher)batcher, dispatcherFactory, nodeFactory, maxActiveSessions){
            final /* synthetic */ Batcher val$batcher;
            final /* synthetic */ CommandDispatcherFactory val$dispatcherFactory;
            final /* synthetic */ NodeFactory val$nodeFactory;
            final /* synthetic */ int val$maxActiveSessions;
            {
                this.val$batcher = batcher;
                this.val$dispatcherFactory = commandDispatcherFactory;
                this.val$nodeFactory = nodeFactory;
                this.val$maxActiveSessions = n;
            }

            @Override
            public SessionContext getSessionContext() {
                return context;
            }

            @Override
            public Cache<String, ?> getCache() {
                return cache;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return this.val$batcher;
            }

            @Override
            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$dispatcherFactory;
            }

            @Override
            public NodeFactory<Address> getNodeFactory() {
                return this.val$nodeFactory;
            }

            @Override
            public int getMaxActiveSessions() {
                return this.val$maxActiveSessions;
            }
        };
        return new InfinispanSessionManager(this.getSessionFactory(context, localContextFactory), config);
    }

    private <L> SessionFactory<?, L> getSessionFactory(SessionContext context, LocalContextFactory<L> localContextFactory) {
        SessionManagerConfiguration config = this.config.getSessionManagerConfiguration();
        Module module = config.getModule();
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)new SessionAttributeMarshallingContext(module), (ClassLoader)module.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        switch (config.getAttributePersistenceStrategy()) {
            case FINE: {
                Cache sessionCache = this.getSessionCache();
                Cache attributeCache = this.config.getCache();
                MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)factory, (Object)marshallingContext);
                return new FineSessionFactory<L>(sessionCache, attributeCache, context, (Marshaller<Object, MarshalledValue<Object, MarshallingContext>>)marshaller, localContextFactory);
            }
            case COARSE: {
                Cache sessionCache = this.getSessionCache();
                Cache attributesCache = this.config.getCache();
                MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)factory, (Object)marshallingContext);
                return new CoarseSessionFactory<L>(sessionCache, attributesCache, context, (Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>>)marshaller, localContextFactory);
            }
        }
        throw new IllegalStateException();
    }

    private <V> Cache<String, V> getSessionCache() {
        AdvancedCache cache = this.config.getCache();
        Configuration cacheConfig = cache.getCacheConfiguration();
        boolean lockOnRead = cacheConfig.transaction().transactionMode().isTransactional() && cacheConfig.transaction().lockingMode() == LockingMode.PESSIMISTIC && cacheConfig.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        return lockOnRead ? cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : cache;
    }
}

