/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.ClusteredQueryCommand;
import org.infinispan.query.clustered.ClusteredQueryInvoker;
import org.infinispan.query.clustered.ClusteredTopDocs;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.query.clustered.DistributedLazyIterator;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.impl.CacheQueryImpl;
import org.infinispan.query.impl.ComponentRegistryUtils;

public class ClusteredCacheQueryImpl
extends CacheQueryImpl {
    private Sort sort;
    private Integer resultSize;
    private final ExecutorService asyncExecutor;
    private int maxResults = 100;
    private int firstResult = 0;
    private Marshaller marshaller;

    public ClusteredCacheQueryImpl(Query luceneQuery, SearchIntegrator searchFactory, ExecutorService asyncExecutor, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, Class<?> ... classes) {
        super(luceneQuery, searchFactory, cache, keyTransformationHandler, classes);
        this.asyncExecutor = asyncExecutor;
        this.hSearchQuery = searchFactory.createHSQuery().luceneQuery(luceneQuery).targetedEntities(Arrays.asList(classes));
        this.marshaller = (Marshaller)ComponentRegistryUtils.getComponent(cache, StreamingMarshaller.class, "org.infinispan.marshaller.cache");
    }

    @Override
    public CacheQuery maxResults(int maxResults) {
        this.maxResults = maxResults;
        return super.maxResults(maxResults);
    }

    @Override
    public CacheQuery firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public CacheQuery sort(Sort sort) {
        this.sort = sort;
        return super.sort(sort);
    }

    @Override
    public int getResultSize() {
        int accumulator;
        if (this.resultSize == null) {
            ClusteredQueryCommand command = ClusteredQueryCommand.getResultSize(this.hSearchQuery, this.cache);
            ClusteredQueryInvoker invoker = new ClusteredQueryInvoker((Cache<?, ?>)this.cache, this.asyncExecutor);
            List<QueryResponse> responses = invoker.broadcast(command);
            accumulator = 0;
            for (QueryResponse response : responses) {
                accumulator += response.getResultSize();
            }
            this.resultSize = accumulator;
        } else {
            accumulator = this.resultSize;
        }
        return accumulator;
    }

    @Override
    public ResultIterator iterator(FetchOptions fetchOptions) throws SearchException {
        this.hSearchQuery.maxResults(this.getNodeMaxResults());
        switch (fetchOptions.getFetchMode()) {
            case EAGER: {
                ClusteredQueryCommand command = ClusteredQueryCommand.createEagerIterator(this.hSearchQuery, this.cache);
                HashMap<UUID, ClusteredTopDocs> topDocsResponses = this.broadcastQuery(command);
                return new DistributedIterator(this.sort, fetchOptions.getFetchSize(), this.resultSize, this.maxResults, this.firstResult, topDocsResponses, this.cache);
            }
            case LAZY: {
                UUID lazyItId = UUID.randomUUID();
                ClusteredQueryCommand command = ClusteredQueryCommand.createLazyIterator(this.hSearchQuery, this.cache, lazyItId);
                HashMap<UUID, ClusteredTopDocs> topDocsResponses = this.broadcastQuery(command);
                return new DistributedLazyIterator(this.sort, fetchOptions.getFetchSize(), this.resultSize, this.maxResults, this.firstResult, lazyItId, topDocsResponses, this.asyncExecutor, this.cache);
            }
        }
        throw new IllegalArgumentException("Unknown FetchMode " + (Object)((Object)fetchOptions.getFetchMode()));
    }

    private int getNodeMaxResults() {
        return this.maxResults + this.firstResult;
    }

    private HashMap<UUID, ClusteredTopDocs> broadcastQuery(ClusteredQueryCommand command) {
        ClusteredQueryInvoker invoker = new ClusteredQueryInvoker((Cache<?, ?>)this.cache, this.asyncExecutor);
        HashMap<UUID, ClusteredTopDocs> topDocsResponses = new HashMap<UUID, ClusteredTopDocs>();
        int resultSize = 0;
        List<QueryResponse> responses = invoker.broadcast(command);
        for (QueryResponse queryResponse : responses) {
            ClusteredTopDocs topDocs = new ClusteredTopDocs(queryResponse.getTopDocs(), queryResponse.getNodeUUID());
            resultSize += queryResponse.getResultSize();
            topDocs.setNodeAddress(queryResponse.getAddress());
            topDocsResponses.put(queryResponse.getNodeUUID(), topDocs);
        }
        this.resultSize = resultSize;
        return topDocsResponses;
    }

    @Override
    public List<Object> list() throws SearchException {
        ResultIterator iterator = this.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
        ArrayList<Object> values = new ArrayList<Object>();
        while (iterator.hasNext()) {
            values.add(iterator.next());
        }
        return values;
    }

    @Override
    public CacheQuery timeout(long timeout, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("Clustered queries do not support timeouts yet.");
    }
}

