/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.lucene.search.SortField;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneSortFieldExternalizer
extends AbstractExternalizer<SortField> {
    public Set<Class<? extends SortField>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{SortField.class});
    }

    public SortField readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return LuceneSortFieldExternalizer.readObjectStatic(input);
    }

    public void writeObject(ObjectOutput output, SortField sortField) throws IOException {
        LuceneSortFieldExternalizer.writeObjectStatic(output, sortField);
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_SORT_FIELD;
    }

    static void writeObjectStatic(ObjectOutput output, SortField sortField) throws IOException {
        output.writeUTF(sortField.getField());
        output.writeObject(sortField.getType());
        output.writeBoolean(sortField.getReverse());
    }

    public static SortField readObjectStatic(ObjectInput input) throws IOException, ClassNotFoundException {
        String fieldName = input.readUTF();
        SortField.Type sortType = (SortField.Type)input.readObject();
        boolean reverseSort = input.readBoolean();
        return new SortField(fieldName, sortType, reverseSort);
    }
}

