/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class PropertiesFileLoader {
    private static final char[] ESCAPE_ARRAY = new char[]{'=', '\\'};
    protected static final String COMMENT_PREFIX = "#";
    public static final Pattern PROPERTY_PATTERN = Pattern.compile("#??([^#]*)=([^=]*)");
    public static final String DISABLE_SUFFIX_KEY = "!disable";
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final String path;
    private final String relativeTo;
    protected File propertiesFile;
    private volatile long fileUpdated = -1L;
    private volatile Properties properties = null;
    private Properties toSave = null;

    public PropertiesFileLoader(String path, String relativeTo) {
        this.path = path;
        this.relativeTo = relativeTo;
    }

    public Injector<PathManager> getPathManagerInjectorInjector() {
        return this.pathManager;
    }

    public void start(StartContext context) throws StartException {
        String file = this.path;
        if (this.relativeTo != null) {
            PathManager pm = (PathManager)this.pathManager.getValue();
            file = pm.resolveRelativePathEntry(file, this.relativeTo);
            pm.registerCallback(this.relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
        }
        this.propertiesFile = new File(file);
        try {
            this.getProperties();
        }
        catch (IOException ioe) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToLoadProperties(ioe);
        }
    }

    public void stop(StopContext context) {
        this.properties.clear();
        this.properties = null;
        this.propertiesFile = null;
    }

    public Properties getProperties() throws IOException {
        this.loadAsRequired();
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAsRequired() throws IOException {
        boolean loadRequired;
        boolean bl = loadRequired = this.properties == null || this.fileUpdated != this.propertiesFile.lastModified();
        if (loadRequired) {
            PropertiesFileLoader propertiesFileLoader = this;
            synchronized (propertiesFileLoader) {
                boolean loadReallyRequired;
                long fileLastModified = this.propertiesFile.lastModified();
                boolean bl2 = loadReallyRequired = this.properties == null || this.fileUpdated != fileLastModified;
                if (loadReallyRequired) {
                    this.load();
                    this.fileUpdated = fileLastModified;
                }
            }
        }
    }

    protected void load() throws IOException {
        DomainManagementLogger.ROOT_LOGGER.debugf("Reloading properties file '%s'", this.propertiesFile.getAbsolutePath());
        Properties props = new Properties();
        try (InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(this.propertiesFile), StandardCharsets.UTF_8);){
            props.load(is);
        }
        this.verifyProperties(props);
        this.properties = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistProperties() throws IOException {
        this.beginPersistence();
        List<String> content = this.readFile(this.propertiesFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.propertiesFile), StandardCharsets.UTF_8));
        try {
            for (String line : content) {
                String trimmed = line.trim();
                if (trimmed.length() == 0) {
                    bw.newLine();
                    continue;
                }
                Matcher matcher = PROPERTY_PATTERN.matcher(trimmed);
                if (matcher.matches()) {
                    String key = matcher.group(1);
                    if (this.toSave.containsKey(key) || this.toSave.containsKey(key + DISABLE_SUFFIX_KEY)) {
                        this.writeProperty(bw, key, matcher.group(2));
                        this.toSave.remove(key);
                        this.toSave.remove(key + DISABLE_SUFFIX_KEY);
                        continue;
                    }
                    this.write(bw, line, true);
                    continue;
                }
                this.write(bw, line, true);
            }
            this.endPersistence(bw);
        }
        finally {
            this.safeClose(bw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> readFile(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedFileReader = new BufferedReader(fileReader);
        ArrayList<String> content = new ArrayList<String>();
        try {
            String line;
            while ((line = bufferedFileReader.readLine()) != null) {
                this.addLineContent(bufferedFileReader, content, line);
            }
        }
        finally {
            this.safeClose(bufferedFileReader);
            this.safeClose(fileReader);
        }
        return content;
    }

    protected void addLineContent(BufferedReader bufferedFileReader, List<String> content, String line) throws IOException {
        content.add(line);
    }

    protected void beginPersistence() throws IOException {
        this.toSave = (Properties)this.properties.clone();
    }

    protected void write(BufferedWriter writer, String line, boolean newLine) throws IOException {
        writer.append(line);
        if (newLine) {
            writer.newLine();
        }
    }

    protected void endPersistence(BufferedWriter writer) throws IOException {
        for (Object currentKey : this.toSave.keySet()) {
            String key = (String)currentKey;
            if (key.contains(DISABLE_SUFFIX_KEY)) continue;
            this.writeProperty(writer, key, null);
        }
        this.toSave = null;
    }

    private void writeProperty(BufferedWriter writer, String key, String currentValue) throws IOException {
        String escapedKey = PropertiesFileLoader.escapeString(key, ESCAPE_ARRAY);
        String value = this.getValue(key, currentValue);
        String newLine = Boolean.valueOf(this.toSave.getProperty(key + DISABLE_SUFFIX_KEY)) != false ? COMMENT_PREFIX + escapedKey + "=" + value : escapedKey + "=" + value;
        this.write(writer, newLine, true);
    }

    private String getValue(String key, String previousValue) {
        String valueUpdated = this.toSave.getProperty(key);
        String value = valueUpdated == null ? previousValue : valueUpdated;
        return value;
    }

    public static String escapeString(String name, char[] escapeArray) {
        Arrays.sort(escapeArray);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Arrays.binarySearch(escapeArray, ch) < 0) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(name, 0, i);
            builder.append('\\').append(ch);
            for (int j = i + 1; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (Arrays.binarySearch(escapeArray, ch) >= 0) {
                    builder.append('\\');
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return name;
    }

    protected void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void verifyProperties(Properties properties) throws IOException {
    }
}

