/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.security.manager.SecurityManagerExtension;

class DeploymentPermissionsResourceDefinition
extends PersistentResourceDefinition {
    static final SimpleAttributeDefinition CLASS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("class", ModelType.STRING).setAllowNull(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition ACTIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("actions", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    private static final ObjectTypeAttributeDefinition PERMISSIONS_VALUE_TYPE = ObjectTypeAttributeDefinition.Builder.of((String)"--this name is ignored--", (AttributeDefinition[])new AttributeDefinition[]{CLASS, NAME, ACTIONS, MODULE}).build();
    private static final AttributeDefinition MAXIMUM_PERMISSIONS = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"maximum-permissions", (ObjectTypeAttributeDefinition)PERMISSIONS_VALUE_TYPE).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    private static final AttributeDefinition MINIMUM_PERMISSIONS = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"minimum-permissions", (ObjectTypeAttributeDefinition)PERMISSIONS_VALUE_TYPE).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final PathElement DEPLOYMENT_PERMISSIONS_PATH = PathElement.pathElement((String)"deployment-permissions", (String)"default");
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MINIMUM_PERMISSIONS, MAXIMUM_PERMISSIONS};
    static final DeploymentPermissionsResourceDefinition INSTANCE = new DeploymentPermissionsResourceDefinition();

    private DeploymentPermissionsResourceDefinition() {
        super(DEPLOYMENT_PERMISSIONS_PATH, (ResourceDescriptionResolver)SecurityManagerExtension.getResolver("deployment-permissions"), (OperationStepHandler)new AbstractAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.unmodifiableCollection(Arrays.asList(ATTRIBUTES));
    }

    static class DeploymentPermissionsResourceXMLBuilder
    extends PersistentResourceXMLDescription.PersistentResourceXMLBuilder {
        protected DeploymentPermissionsResourceXMLBuilder() {
            super((PersistentResourceDefinition)INSTANCE);
        }

        public PersistentResourceXMLDescription build() {
            return new DeploymentPermissionsResourceXMLDescription(this.resourceDefinition, this.xmlElementName, this.xmlWrapperElement, this.attributes, new ArrayList<PersistentResourceXMLDescription>(), this.useValueAsElementName, this.noAddOperation, this.additionalOperationsGenerator);
        }
    }

    static class DeploymentPermissionsResourceXMLDescription
    extends PersistentResourceXMLDescription {
        protected DeploymentPermissionsResourceXMLDescription(PersistentResourceDefinition resourceDefinition, String xmlElementName, String xmlWrapperElement, LinkedHashMap<String, AttributeDefinition> attributes, List<PersistentResourceXMLDescription> children, boolean useValueAsElementName, boolean noAddOperation, PersistentResourceXMLDescription.AdditionalOperationsGenerator additionalOperationsGenerator) {
            super(resourceDefinition, xmlElementName, xmlWrapperElement, attributes, children, useValueAsElementName, noAddOperation, additionalOperationsGenerator, null);
        }

        public void parse(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
            ModelNode add = Util.createAddOperation();
            add.get("address").set(parentAddress.append(new PathElement[]{this.resourceDefinition.getPathElement()}).toModelNode());
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(add);
            block8: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (reader.getLocalName()) {
                    case "maximum-set": {
                        add.get(MAXIMUM_PERMISSIONS.getName()).set(this.parsePermissionSet(reader));
                        continue block8;
                    }
                    case "minimum-set": {
                        add.get(MINIMUM_PERMISSIONS.getName()).set(this.parsePermissionSet(reader));
                        continue block8;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private ModelNode parsePermissionSet(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode permissions = new ModelNode();
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (reader.getLocalName()) {
                    case "permission": {
                        permissions.add(this.parsePermission(reader));
                        continue block6;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return permissions;
        }

        private ModelNode parsePermission(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode permission = new ModelNode();
            int count = reader.getAttributeCount();
            block12: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                switch (reader.getAttributeLocalName(i)) {
                    case "class": {
                        CLASS.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                        continue block12;
                    }
                    case "actions": {
                        ACTIONS.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                        continue block12;
                    }
                    case "module": {
                        MODULE.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                        continue block12;
                    }
                    case "name": {
                        NAME.parseAndSetParameter(value, permission, (XMLStreamReader)reader);
                        continue block12;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!permission.hasDefined("class")) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("class"));
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return permission;
        }

        public void persist(XMLExtendedStreamWriter writer, ModelNode model, String namespaceURI) throws XMLStreamException {
            if (!model.hasDefined(new String[]{DEPLOYMENT_PERMISSIONS_PATH.getKey(), DEPLOYMENT_PERMISSIONS_PATH.getValue()})) {
                return;
            }
            ModelNode deploymentPermissions = model.get(new String[]{DEPLOYMENT_PERMISSIONS_PATH.getKey(), DEPLOYMENT_PERMISSIONS_PATH.getValue()});
            writer.writeStartElement(this.xmlElementName);
            if (deploymentPermissions.hasDefined(MINIMUM_PERMISSIONS.getName())) {
                this.persistPermissionSet(writer, deploymentPermissions.get(MINIMUM_PERMISSIONS.getName()), "minimum-set");
            }
            if (deploymentPermissions.hasDefined(MAXIMUM_PERMISSIONS.getName())) {
                this.persistPermissionSet(writer, deploymentPermissions.get(MAXIMUM_PERMISSIONS.getName()), "maximum-set");
            }
            writer.writeEndElement();
        }

        private void persistPermissionSet(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
            if (model.isDefined()) {
                writer.writeStartElement(name);
                for (ModelNode permission : model.asList()) {
                    writer.writeStartElement("permission");
                    CLASS.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                    NAME.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                    ACTIONS.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                    MODULE.marshallAsAttribute(permission, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    }
}

