/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.SharedCacheMode;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.common.reflection.ClassLoaderDelegate;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.util.StandardClassLoaderDelegateImpl;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.archive.scan.internal.StandardScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.cfgxml.spi.MappingReference;
import org.hibernate.boot.internal.IdGeneratorInterpreterImpl;
import org.hibernate.boot.model.IdGeneratorStrategyInterpreter;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.model.process.spi.MetadataBuildingProcess;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.boot.spi.MetadataBuilderInitializer;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.MetadataSourcesContributor;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.AttributeConverterDefinition;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.cfg.annotations.reflection.JPAMetadataProvider;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CustomType;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jboss.jandex.IndexView;

public class MetadataBuilderImpl
implements MetadataBuilderImplementor,
TypeContributions {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MetadataBuilderImpl.class);
    private final MetadataSources sources;
    private final MetadataBuildingOptionsImpl options;

    public MetadataBuilderImpl(MetadataSources sources) {
        this(sources, MetadataBuilderImpl.getStandardServiceRegistry(sources.getServiceRegistry()));
    }

    private static StandardServiceRegistry getStandardServiceRegistry(ServiceRegistry serviceRegistry) {
        if (serviceRegistry == null) {
            throw new HibernateException("ServiceRegistry passed to MetadataBuilder cannot be null");
        }
        if (StandardServiceRegistry.class.isInstance(serviceRegistry)) {
            return (StandardServiceRegistry)serviceRegistry;
        }
        if (BootstrapServiceRegistry.class.isInstance(serviceRegistry)) {
            log.debugf("ServiceRegistry passed to MetadataBuilder was a BootstrapServiceRegistry; this likely wont end wellif attempt is made to build SessionFactory", new Object[0]);
            return new StandardServiceRegistryBuilder((BootstrapServiceRegistry)serviceRegistry).build();
        }
        throw new HibernateException(String.format("Unexpected type of ServiceRegistry [%s] encountered in attempt to build MetadataBuilder", serviceRegistry.getClass().getName()));
    }

    public MetadataBuilderImpl(MetadataSources sources, StandardServiceRegistry serviceRegistry) {
        this.sources = sources;
        this.options = new MetadataBuildingOptionsImpl(serviceRegistry);
        for (MetadataSourcesContributor contributor : sources.getServiceRegistry().getService(ClassLoaderService.class).loadJavaServices(MetadataSourcesContributor.class)) {
            contributor.contribute(sources);
        }
        this.applyCfgXmlValues(serviceRegistry.getService(CfgXmlAccessService.class));
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        for (MetadataBuilderInitializer contributor : classLoaderService.loadJavaServices(MetadataBuilderInitializer.class)) {
            contributor.contribute(this, serviceRegistry);
        }
    }

    private void applyCfgXmlValues(CfgXmlAccessService service) {
        LoadedConfig aggregatedConfig = service.getAggregatedConfig();
        if (aggregatedConfig == null) {
            return;
        }
        for (CacheRegionDefinition cacheRegionDefinition : aggregatedConfig.getCacheRegionDefinitions()) {
            this.applyCacheRegionDefinition(cacheRegionDefinition);
        }
    }

    @Override
    public MetadataBuilder applyImplicitSchemaName(String implicitSchemaName) {
        this.options.mappingDefaults.implicitSchemaName = implicitSchemaName;
        return this;
    }

    @Override
    public MetadataBuilder applyImplicitCatalogName(String implicitCatalogName) {
        this.options.mappingDefaults.implicitCatalogName = implicitCatalogName;
        return this;
    }

    @Override
    public MetadataBuilder applyImplicitNamingStrategy(ImplicitNamingStrategy namingStrategy) {
        this.options.implicitNamingStrategy = namingStrategy;
        return this;
    }

    @Override
    public MetadataBuilder applyPhysicalNamingStrategy(PhysicalNamingStrategy namingStrategy) {
        this.options.physicalNamingStrategy = namingStrategy;
        return this;
    }

    @Override
    public MetadataBuilder applyReflectionManager(ReflectionManager reflectionManager) {
        this.options.reflectionManager = reflectionManager;
        this.options.reflectionManager.injectClassLoaderDelegate(this.options.getHcannClassLoaderDelegate());
        return this;
    }

    @Override
    public MetadataBuilder applySharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.options.sharedCacheMode = sharedCacheMode;
        return this;
    }

    @Override
    public MetadataBuilder applyAccessType(AccessType implicitCacheAccessType) {
        this.options.mappingDefaults.implicitCacheAccessType = implicitCacheAccessType;
        return this;
    }

    @Override
    public MetadataBuilder applyIndexView(IndexView jandexView) {
        this.options.jandexView = jandexView;
        return this;
    }

    @Override
    public MetadataBuilder applyScanOptions(ScanOptions scanOptions) {
        this.options.scanOptions = scanOptions;
        return this;
    }

    @Override
    public MetadataBuilder applyScanEnvironment(ScanEnvironment scanEnvironment) {
        this.options.scanEnvironment = scanEnvironment;
        return this;
    }

    @Override
    public MetadataBuilder applyScanner(Scanner scanner) {
        this.options.scannerSetting = scanner;
        return this;
    }

    @Override
    public MetadataBuilder applyArchiveDescriptorFactory(ArchiveDescriptorFactory factory) {
        this.options.archiveDescriptorFactory = factory;
        return this;
    }

    @Override
    public MetadataBuilder enableExplicitDiscriminatorsForJoinedSubclassSupport(boolean supported) {
        this.options.explicitDiscriminatorsForJoinedInheritanceSupported = supported;
        return this;
    }

    @Override
    public MetadataBuilder enableImplicitDiscriminatorsForJoinedSubclassSupport(boolean supported) {
        this.options.implicitDiscriminatorsForJoinedInheritanceSupported = supported;
        return this;
    }

    @Override
    public MetadataBuilder enableImplicitForcingOfDiscriminatorsInSelect(boolean supported) {
        this.options.implicitlyForceDiscriminatorInSelect = supported;
        return this;
    }

    @Override
    public MetadataBuilder enableGlobalNationalizedCharacterDataSupport(boolean enabled) {
        this.options.useNationalizedCharacterData = enabled;
        return this;
    }

    @Override
    public MetadataBuilder applyBasicType(BasicType type) {
        this.options.basicTypeRegistrations.add(type);
        return this;
    }

    @Override
    public MetadataBuilder applyBasicType(UserType type, String[] keys) {
        this.options.basicTypeRegistrations.add(new CustomType(type, keys));
        return this;
    }

    @Override
    public MetadataBuilder applyBasicType(CompositeUserType type, String[] keys) {
        this.options.basicTypeRegistrations.add(new CompositeCustomType(type, keys));
        return this;
    }

    @Override
    public MetadataBuilder applyTypes(TypeContributor typeContributor) {
        typeContributor.contribute(this, this.options.serviceRegistry);
        return this;
    }

    @Override
    public void contributeType(BasicType type) {
        this.options.basicTypeRegistrations.add(type);
    }

    @Override
    public void contributeType(UserType type, String[] keys) {
        this.options.basicTypeRegistrations.add(new CustomType(type, keys));
    }

    @Override
    public void contributeType(CompositeUserType type, String[] keys) {
        this.options.basicTypeRegistrations.add(new CompositeCustomType(type, keys));
    }

    @Override
    public MetadataBuilder applyCacheRegionDefinition(CacheRegionDefinition cacheRegionDefinition) {
        if (this.options.cacheRegionDefinitions == null) {
            this.options.cacheRegionDefinitions = new ArrayList();
        }
        this.options.cacheRegionDefinitions.add(cacheRegionDefinition);
        return this;
    }

    @Override
    public MetadataBuilder applyTempClassLoader(ClassLoader tempClassLoader) {
        this.options.tempClassLoader = tempClassLoader;
        return this;
    }

    @Override
    public MetadataBuilder applySourceProcessOrdering(MetadataSourceType ... sourceTypes) {
        this.options.sourceProcessOrdering.addAll(Arrays.asList(sourceTypes));
        return this;
    }

    public MetadataBuilder allowSpecjSyntax() {
        this.options.specjProprietarySyntaxEnabled = true;
        return this;
    }

    @Override
    public MetadataBuilder applySqlFunction(String functionName, SQLFunction function) {
        if (this.options.sqlFunctionMap == null) {
            this.options.sqlFunctionMap = new HashMap();
        }
        this.options.sqlFunctionMap.put(functionName, function);
        return this;
    }

    @Override
    public MetadataBuilder applyAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        if (this.options.auxiliaryDatabaseObjectList == null) {
            this.options.auxiliaryDatabaseObjectList = new ArrayList();
        }
        this.options.auxiliaryDatabaseObjectList.add(auxiliaryDatabaseObject);
        return this;
    }

    @Override
    public MetadataBuilder applyAttributeConverter(AttributeConverterDefinition definition) {
        this.options.addAttributeConverterDefinition(definition);
        return this;
    }

    @Override
    public MetadataBuilder applyAttributeConverter(Class<? extends AttributeConverter> attributeConverterClass) {
        this.applyAttributeConverter(AttributeConverterDefinition.from(attributeConverterClass));
        return this;
    }

    @Override
    public MetadataBuilder applyAttributeConverter(Class<? extends AttributeConverter> attributeConverterClass, boolean autoApply) {
        this.applyAttributeConverter(AttributeConverterDefinition.from(attributeConverterClass, autoApply));
        return this;
    }

    @Override
    public MetadataBuilder applyAttributeConverter(AttributeConverter attributeConverter) {
        this.applyAttributeConverter(AttributeConverterDefinition.from(attributeConverter));
        return this;
    }

    @Override
    public MetadataBuilder applyAttributeConverter(AttributeConverter attributeConverter, boolean autoApply) {
        this.applyAttributeConverter(AttributeConverterDefinition.from(attributeConverter, autoApply));
        return this;
    }

    @Override
    public MetadataBuilder enableNewIdentifierGeneratorSupport(boolean enabled) {
        if (enabled) {
            this.options.idGenerationTypeInterpreter.disableLegacyFallback();
        } else {
            this.options.idGenerationTypeInterpreter.enableLegacyFallback();
        }
        return this;
    }

    @Override
    public MetadataBuilder applyIdGenerationTypeInterpreter(IdGeneratorStrategyInterpreter interpreter) {
        this.options.idGenerationTypeInterpreter.addInterpreterDelegate(interpreter);
        return this;
    }

    @Override
    public <T extends MetadataBuilder> T unwrap(Class<T> type) {
        return (T)this;
    }

    @Override
    public MetadataImplementor build() {
        CfgXmlAccessService cfgXmlAccessService = this.options.serviceRegistry.getService(CfgXmlAccessService.class);
        if (cfgXmlAccessService.getAggregatedConfig() != null && cfgXmlAccessService.getAggregatedConfig().getMappingReferences() != null) {
            for (MappingReference mappingReference : cfgXmlAccessService.getAggregatedConfig().getMappingReferences()) {
                mappingReference.apply(this.sources);
            }
        }
        return MetadataBuildingProcess.build(this.sources, this.options);
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.options;
    }

    public static class MetadataBuildingOptionsImpl
    implements MetadataBuildingOptions {
        private final StandardServiceRegistry serviceRegistry;
        private final MappingDefaultsImpl mappingDefaults;
        private ArrayList<BasicType> basicTypeRegistrations = new ArrayList();
        private IndexView jandexView;
        private ClassLoader tempClassLoader;
        private ScanOptions scanOptions;
        private ScanEnvironment scanEnvironment;
        private Object scannerSetting;
        private ArchiveDescriptorFactory archiveDescriptorFactory;
        private ImplicitNamingStrategy implicitNamingStrategy;
        private PhysicalNamingStrategy physicalNamingStrategy;
        private ReflectionManager reflectionManager;
        private ClassLoaderDelegate hcannClassLoaderDelegate;
        private SharedCacheMode sharedCacheMode;
        private AccessType defaultCacheAccessType;
        private MultiTenancyStrategy multiTenancyStrategy;
        private ArrayList<CacheRegionDefinition> cacheRegionDefinitions;
        private boolean explicitDiscriminatorsForJoinedInheritanceSupported;
        private boolean implicitDiscriminatorsForJoinedInheritanceSupported;
        private boolean implicitlyForceDiscriminatorInSelect;
        private boolean useNationalizedCharacterData;
        private boolean specjProprietarySyntaxEnabled;
        private ArrayList<MetadataSourceType> sourceProcessOrdering;
        private HashMap<String, SQLFunction> sqlFunctionMap;
        private ArrayList<AuxiliaryDatabaseObject> auxiliaryDatabaseObjectList;
        private HashMap<Class, AttributeConverterDefinition> attributeConverterDefinitionsByClass;
        private IdGeneratorInterpreterImpl idGenerationTypeInterpreter = new IdGeneratorInterpreterImpl();
        private boolean autoQuoteKeywords;

        public MetadataBuildingOptionsImpl(StandardServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
            ConfigurationService configService = serviceRegistry.getService(ConfigurationService.class);
            this.mappingDefaults = new MappingDefaultsImpl(serviceRegistry);
            this.scanOptions = new StandardScanOptions((String)configService.getSettings().get("hibernate.archive.autodetection"), false);
            this.scannerSetting = configService.getSettings().get("hibernate.archive.scanner");
            if (this.scannerSetting == null) {
                this.scannerSetting = configService.getSettings().get("hibernate.ejb.resource_scanner");
                if (this.scannerSetting != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedScannerSetting();
                }
            }
            this.archiveDescriptorFactory = strategySelector.resolveStrategy(ArchiveDescriptorFactory.class, configService.getSettings().get("hibernate.archive.interpreter"));
            this.multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(configService.getSettings());
            this.implicitDiscriminatorsForJoinedInheritanceSupported = configService.getSetting("hibernate.discriminator.implicit_for_joined", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.explicitDiscriminatorsForJoinedInheritanceSupported = configService.getSetting("hibernate.discriminator.ignore_explicit_for_joined", StandardConverters.BOOLEAN, Boolean.valueOf(false)) == false;
            this.implicitlyForceDiscriminatorInSelect = configService.getSetting("hibernate.discriminator.force_in_select", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.sharedCacheMode = configService.getSetting("javax.persistence.sharedCache.mode", new ConfigurationService.Converter<SharedCacheMode>(){

                @Override
                public SharedCacheMode convert(Object value) {
                    if (value == null) {
                        return null;
                    }
                    if (SharedCacheMode.class.isInstance(value)) {
                        return (SharedCacheMode)value;
                    }
                    return SharedCacheMode.valueOf((String)value.toString());
                }
            }, SharedCacheMode.UNSPECIFIED);
            this.defaultCacheAccessType = configService.getSetting("hibernate.cache.default_cache_concurrency_strategy", new ConfigurationService.Converter<AccessType>(){

                @Override
                public AccessType convert(Object value) {
                    if (value == null) {
                        return null;
                    }
                    if (CacheConcurrencyStrategy.class.isInstance(value)) {
                        return ((CacheConcurrencyStrategy)((Object)value)).toAccessType();
                    }
                    if (AccessType.class.isInstance(value)) {
                        return (AccessType)((Object)value);
                    }
                    return AccessType.fromExternalName(value.toString());
                }
            }, serviceRegistry.getService(RegionFactory.class) == null ? null : serviceRegistry.getService(RegionFactory.class).getDefaultAccessType());
            this.specjProprietarySyntaxEnabled = configService.getSetting("hibernate.enable_specj_proprietary_syntax", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.implicitNamingStrategy = strategySelector.resolveDefaultableStrategy(ImplicitNamingStrategy.class, configService.getSettings().get("hibernate.implicit_naming_strategy"), ImplicitNamingStrategyLegacyJpaImpl.INSTANCE);
            this.physicalNamingStrategy = strategySelector.resolveDefaultableStrategy(PhysicalNamingStrategy.class, configService.getSettings().get("hibernate.physical_naming_strategy"), PhysicalNamingStrategyStandardImpl.INSTANCE);
            this.sourceProcessOrdering = this.resolveInitialSourceProcessOrdering(configService);
            boolean useNewIdentifierGenerators = configService.getSetting("hibernate.id.new_generator_mappings", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            if (useNewIdentifierGenerators) {
                this.idGenerationTypeInterpreter.disableLegacyFallback();
            } else {
                this.idGenerationTypeInterpreter.enableLegacyFallback();
            }
            this.reflectionManager = this.generateDefaultReflectionManager();
        }

        private ArrayList<MetadataSourceType> resolveInitialSourceProcessOrdering(ConfigurationService configService) {
            ArrayList<MetadataSourceType> initialSelections = new ArrayList<MetadataSourceType>();
            String sourceProcessOrderingSetting = configService.getSetting("hibernate.mapping.precedence", StandardConverters.STRING);
            if (sourceProcessOrderingSetting != null) {
                String[] orderChoices = StringHelper.split(",; ", sourceProcessOrderingSetting, false);
                initialSelections.addAll(CollectionHelper.arrayList(orderChoices.length));
                for (String orderChoice : orderChoices) {
                    initialSelections.add(MetadataSourceType.parsePrecedence(orderChoice));
                }
            }
            if (initialSelections.isEmpty()) {
                initialSelections.add(MetadataSourceType.HBM);
                initialSelections.add(MetadataSourceType.CLASS);
            }
            return initialSelections;
        }

        private ReflectionManager generateDefaultReflectionManager() {
            JavaReflectionManager reflectionManager = new JavaReflectionManager();
            reflectionManager.setMetadataProvider((MetadataProvider)new JPAMetadataProvider(this));
            reflectionManager.injectClassLoaderDelegate(this.getHcannClassLoaderDelegate());
            return reflectionManager;
        }

        public ClassLoaderDelegate getHcannClassLoaderDelegate() {
            if (this.hcannClassLoaderDelegate == null) {
                this.hcannClassLoaderDelegate = new ClassLoaderDelegate(){
                    private final ClassLoaderService classLoaderService;
                    {
                        this.classLoaderService = MetadataBuildingOptionsImpl.this.getServiceRegistry().getService(ClassLoaderService.class);
                    }

                    public <T> Class<T> classForName(String className) throws org.hibernate.annotations.common.reflection.ClassLoadingException {
                        try {
                            return this.classLoaderService.classForName(className);
                        }
                        catch (ClassLoadingException e) {
                            return StandardClassLoaderDelegateImpl.INSTANCE.classForName(className);
                        }
                    }
                };
            }
            return this.hcannClassLoaderDelegate;
        }

        @Override
        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public MappingDefaults getMappingDefaults() {
            return this.mappingDefaults;
        }

        @Override
        public List<BasicType> getBasicTypeRegistrations() {
            return this.basicTypeRegistrations;
        }

        @Override
        public IndexView getJandexView() {
            return this.jandexView;
        }

        @Override
        public ScanOptions getScanOptions() {
            return this.scanOptions;
        }

        @Override
        public ScanEnvironment getScanEnvironment() {
            return this.scanEnvironment;
        }

        @Override
        public Object getScanner() {
            return this.scannerSetting;
        }

        @Override
        public ArchiveDescriptorFactory getArchiveDescriptorFactory() {
            return this.archiveDescriptorFactory;
        }

        @Override
        public ClassLoader getTempClassLoader() {
            return this.tempClassLoader;
        }

        @Override
        public ImplicitNamingStrategy getImplicitNamingStrategy() {
            return this.implicitNamingStrategy;
        }

        @Override
        public PhysicalNamingStrategy getPhysicalNamingStrategy() {
            return this.physicalNamingStrategy;
        }

        @Override
        public ReflectionManager getReflectionManager() {
            return this.reflectionManager;
        }

        @Override
        public SharedCacheMode getSharedCacheMode() {
            return this.sharedCacheMode;
        }

        @Override
        public AccessType getImplicitCacheAccessType() {
            return this.defaultCacheAccessType;
        }

        @Override
        public MultiTenancyStrategy getMultiTenancyStrategy() {
            return this.multiTenancyStrategy;
        }

        @Override
        public IdGeneratorStrategyInterpreter getIdGenerationTypeInterpreter() {
            return this.idGenerationTypeInterpreter;
        }

        @Override
        public List<CacheRegionDefinition> getCacheRegionDefinitions() {
            return this.cacheRegionDefinitions;
        }

        @Override
        public boolean ignoreExplicitDiscriminatorsForJoinedInheritance() {
            return !this.explicitDiscriminatorsForJoinedInheritanceSupported;
        }

        @Override
        public boolean createImplicitDiscriminatorsForJoinedInheritance() {
            return this.implicitDiscriminatorsForJoinedInheritanceSupported;
        }

        @Override
        public boolean shouldImplicitlyForceDiscriminatorInSelect() {
            return this.implicitlyForceDiscriminatorInSelect;
        }

        @Override
        public boolean useNationalizedCharacterData() {
            return this.useNationalizedCharacterData;
        }

        @Override
        public boolean isSpecjProprietarySyntaxEnabled() {
            return this.specjProprietarySyntaxEnabled;
        }

        @Override
        public List<MetadataSourceType> getSourceProcessOrdering() {
            return this.sourceProcessOrdering;
        }

        @Override
        public Map<String, SQLFunction> getSqlFunctions() {
            return this.sqlFunctionMap == null ? Collections.emptyMap() : this.sqlFunctionMap;
        }

        @Override
        public List<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjectList() {
            return this.auxiliaryDatabaseObjectList == null ? Collections.emptyList() : this.auxiliaryDatabaseObjectList;
        }

        @Override
        public List<AttributeConverterDefinition> getAttributeConverters() {
            return this.attributeConverterDefinitionsByClass == null ? Collections.emptyList() : new ArrayList<AttributeConverterDefinition>(this.attributeConverterDefinitionsByClass.values());
        }

        public void addAttributeConverterDefinition(AttributeConverterDefinition definition) {
            AttributeConverterDefinition old;
            if (this.attributeConverterDefinitionsByClass == null) {
                this.attributeConverterDefinitionsByClass = new HashMap();
            }
            if ((old = this.attributeConverterDefinitionsByClass.put(definition.getAttributeConverter().getClass(), definition)) != null) {
                throw new AssertionFailure(String.format("AttributeConverter class [%s] registered multiple times", definition.getAttributeConverter().getClass()));
            }
        }

        public void apply(JpaOrmXmlPersistenceUnitDefaults jpaOrmXmlPersistenceUnitDefaults) {
            if (!this.mappingDefaults.shouldImplicitlyQuoteIdentifiers()) {
                this.mappingDefaults.implicitlyQuoteIdentifiers = jpaOrmXmlPersistenceUnitDefaults.shouldImplicitlyQuoteIdentifiers();
            }
            if (this.mappingDefaults.getImplicitCatalogName() == null) {
                this.mappingDefaults.implicitCatalogName = StringHelper.nullIfEmpty(jpaOrmXmlPersistenceUnitDefaults.getDefaultCatalogName());
            }
            if (this.mappingDefaults.getImplicitSchemaName() == null) {
                this.mappingDefaults.implicitSchemaName = StringHelper.nullIfEmpty(jpaOrmXmlPersistenceUnitDefaults.getDefaultSchemaName());
            }
        }

        public static interface JpaOrmXmlPersistenceUnitDefaults {
            public String getDefaultSchemaName();

            public String getDefaultCatalogName();

            public boolean shouldImplicitlyQuoteIdentifiers();
        }
    }

    public static class MappingDefaultsImpl
    implements MappingDefaults {
        private String implicitSchemaName;
        private String implicitCatalogName;
        private boolean implicitlyQuoteIdentifiers;
        private AccessType implicitCacheAccessType;

        public MappingDefaultsImpl(StandardServiceRegistry serviceRegistry) {
            ConfigurationService configService = serviceRegistry.getService(ConfigurationService.class);
            this.implicitSchemaName = configService.getSetting("hibernate.default_schema", StandardConverters.STRING, null);
            this.implicitCatalogName = configService.getSetting("hibernate.default_catalog", StandardConverters.STRING, null);
            this.implicitlyQuoteIdentifiers = configService.getSetting("hibernate.globally_quoted_identifiers", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.implicitCacheAccessType = configService.getSetting("hibernate.cache.default_cache_concurrency_strategy", new ConfigurationService.Converter<AccessType>(){

                @Override
                public AccessType convert(Object value) {
                    return AccessType.fromExternalName(value.toString());
                }
            });
        }

        @Override
        public String getImplicitSchemaName() {
            return this.implicitSchemaName;
        }

        @Override
        public String getImplicitCatalogName() {
            return this.implicitCatalogName;
        }

        @Override
        public boolean shouldImplicitlyQuoteIdentifiers() {
            return this.implicitlyQuoteIdentifiers;
        }

        @Override
        public String getImplicitIdColumnName() {
            return "id";
        }

        @Override
        public String getImplicitTenantIdColumnName() {
            return "tenant_id";
        }

        @Override
        public String getImplicitDiscriminatorColumnName() {
            return "class";
        }

        @Override
        public String getImplicitPackageName() {
            return null;
        }

        @Override
        public boolean isAutoImportEnabled() {
            return true;
        }

        @Override
        public String getImplicitCascadeStyleName() {
            return "none";
        }

        @Override
        public String getImplicitPropertyAccessorName() {
            return "property";
        }

        @Override
        public boolean areEntitiesImplicitlyLazy() {
            return false;
        }

        @Override
        public boolean areCollectionsImplicitlyLazy() {
            return true;
        }

        @Override
        public AccessType getImplicitCacheAccessType() {
            return this.implicitCacheAccessType;
        }
    }
}

