/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi.interceptor;

import java.util.Set;
import org.hibernate.LazyInitializationException;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleDirtyTracker;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionImplementor;

public class LazyAttributeLoader
implements PersistentAttributeInterceptor {
    private final transient SessionImplementor session;
    private final Set<String> lazyFields;
    private final String entityName;
    private final SimpleDirtyTracker initializedFields = new SimpleDirtyTracker();

    public LazyAttributeLoader(SessionImplementor session, Set<String> lazyFields, String entityName) {
        this.session = session;
        this.lazyFields = lazyFields;
        this.entityName = entityName;
    }

    protected final Object intercept(Object target, String fieldName, Object value) {
        if (this.lazyFields != null && this.lazyFields.contains(fieldName) && !this.initializedFields.contains(fieldName)) {
            if (this.session == null) {
                throw new LazyInitializationException("entity with lazy properties is not associated with a session");
            }
            if (!this.session.isOpen() || !this.session.isConnected()) {
                throw new LazyInitializationException("session is not connected");
            }
            Object loadedValue = ((LazyPropertyInitializer)((Object)this.session.getFactory().getEntityPersister(this.entityName))).initializeLazyProperty(fieldName, target, this.session);
            this.initializedFields.add(fieldName);
            return loadedValue;
        }
        return value;
    }

    public String toString() {
        return "LazyAttributeLoader(entityName=" + this.entityName + " ,lazyFields=" + this.lazyFields + ')';
    }

    @Override
    public boolean readBoolean(Object obj, String name, boolean oldValue) {
        return (Boolean)this.intercept(obj, name, oldValue);
    }

    @Override
    public boolean writeBoolean(Object obj, String name, boolean oldValue, boolean newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public byte readByte(Object obj, String name, byte oldValue) {
        return (Byte)this.intercept(obj, name, oldValue);
    }

    @Override
    public byte writeByte(Object obj, String name, byte oldValue, byte newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public char readChar(Object obj, String name, char oldValue) {
        return ((Character)this.intercept(obj, name, Character.valueOf(oldValue))).charValue();
    }

    @Override
    public char writeChar(Object obj, String name, char oldValue, char newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public short readShort(Object obj, String name, short oldValue) {
        return (Short)this.intercept(obj, name, oldValue);
    }

    @Override
    public short writeShort(Object obj, String name, short oldValue, short newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public int readInt(Object obj, String name, int oldValue) {
        return (Integer)this.intercept(obj, name, oldValue);
    }

    @Override
    public int writeInt(Object obj, String name, int oldValue, int newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public float readFloat(Object obj, String name, float oldValue) {
        return ((Float)this.intercept(obj, name, Float.valueOf(oldValue))).floatValue();
    }

    @Override
    public float writeFloat(Object obj, String name, float oldValue, float newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public double readDouble(Object obj, String name, double oldValue) {
        return (Double)this.intercept(obj, name, oldValue);
    }

    @Override
    public double writeDouble(Object obj, String name, double oldValue, double newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public long readLong(Object obj, String name, long oldValue) {
        return (Long)this.intercept(obj, name, oldValue);
    }

    @Override
    public long writeLong(Object obj, String name, long oldValue, long newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }

    @Override
    public Object readObject(Object obj, String name, Object oldValue) {
        return this.intercept(obj, name, oldValue);
    }

    @Override
    public Object writeObject(Object obj, String name, Object oldValue, Object newValue) {
        if (this.lazyFields != null && this.lazyFields.contains(name)) {
            this.initializedFields.add(name);
        }
        return newValue;
    }
}

