/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.ConstructorConfig;
import org.jboss.as.pojo.descriptor.FactoryConfig;
import org.jboss.as.pojo.descriptor.LifecycleConfig;
import org.jboss.as.pojo.descriptor.PropertyConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.logging.PojoLogger;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.Configurator;
import org.jboss.as.pojo.service.ConstructorJoinpoint;
import org.jboss.as.pojo.service.Joinpoint;
import org.jboss.as.pojo.service.MethodJoinpoint;
import org.jboss.as.pojo.service.ReflectionJoinpoint;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.modules.Module;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public final class BeanUtils {
    public static Object instantiateBean(BeanMetaDataConfig beanConfig, BeanInfo beanInfo, DeploymentReflectionIndex index, Module module) throws Throwable {
        Joinpoint instantiateJoinpoint = null;
        ValueConfig[] parameters = new ValueConfig[]{};
        String[] types = Configurator.NO_PARAMS_TYPES;
        ConstructorConfig ctorConfig = beanConfig.getConstructor();
        if (ctorConfig != null) {
            parameters = ctorConfig.getParameters();
            types = Configurator.getTypes(parameters);
            String factoryClass = ctorConfig.getFactoryClass();
            FactoryConfig factory = ctorConfig.getFactory();
            if (factoryClass != null || factory != null) {
                String factoryMethod = ctorConfig.getFactoryMethod();
                if (factoryMethod == null) {
                    throw PojoLogger.ROOT_LOGGER.missingFactoryMethod(beanConfig);
                }
                if (factoryClass != null) {
                    Class<?> factoryClazz = Class.forName(factoryClass, false, (ClassLoader)module.getClassLoader());
                    Method method = Configurator.findMethod(index, factoryClazz, factoryMethod, types, true, true, true);
                    MethodJoinpoint mj = new MethodJoinpoint(method);
                    mj.setTarget((Value<Object>)new ImmediateValue(null));
                    mj.setParameters(parameters);
                    instantiateJoinpoint = mj;
                } else if (factory != null) {
                    ReflectionJoinpoint rj = new ReflectionJoinpoint(factory.getBeanInfo(), factoryMethod, types);
                    rj.setTarget((Value<Object>)new ImmediateValue(factory.getValue(null)));
                    rj.setParameters(parameters);
                    instantiateJoinpoint = rj;
                }
            }
        }
        if (instantiateJoinpoint == null) {
            if (beanInfo == null) {
                throw new StartException(PojoLogger.ROOT_LOGGER.missingBeanInfo(beanConfig));
            }
            Constructor ctor = types.length == 0 ? beanInfo.getConstructor(new String[0]) : beanInfo.findConstructor(types);
            ConstructorJoinpoint constructorJoinpoint = new ConstructorJoinpoint(ctor);
            constructorJoinpoint.setParameters(parameters);
            instantiateJoinpoint = constructorJoinpoint;
        }
        return instantiateJoinpoint.dispatch();
    }

    public static void configure(BeanMetaDataConfig beanConfig, BeanInfo beanInfo, Module module, Object bean, boolean nullify) throws Throwable {
        Set<PropertyConfig> properties = beanConfig.getProperties();
        if (properties != null) {
            ArrayList<PropertyConfig> used = new ArrayList<PropertyConfig>();
            for (PropertyConfig pc : properties) {
                try {
                    BeanUtils.configure(beanInfo, module, bean, pc, nullify);
                    used.add(pc);
                }
                catch (Throwable t) {
                    if (nullify) continue;
                    for (PropertyConfig upc : used) {
                        try {
                            BeanUtils.configure(beanInfo, module, bean, upc, true);
                        }
                        catch (Throwable ignored) {}
                    }
                    throw new StartException(t);
                }
            }
        }
    }

    public static void dispatchLifecycleJoinpoint(BeanInfo beanInfo, Object bean, LifecycleConfig config, String defaultMethod) throws Throwable {
        if (config != null && config.isIgnored()) {
            return;
        }
        Joinpoint joinpoint = BeanUtils.createJoinpoint(beanInfo, bean, config, defaultMethod);
        if (joinpoint != null) {
            joinpoint.dispatch();
        }
    }

    private static Joinpoint createJoinpoint(BeanInfo beanInfo, Object bean, LifecycleConfig config, String defaultMethod) {
        Method method;
        ValueConfig[] params = null;
        if (config == null) {
            try {
                method = beanInfo.getMethod(defaultMethod, new String[0]);
            }
            catch (Exception t) {
                PojoLogger.ROOT_LOGGER.tracef(t, "Ignoring default %s invocation.", defaultMethod);
                return null;
            }
        } else {
            String methodName = config.getMethodName();
            if (methodName == null) {
                methodName = defaultMethod;
            }
            ValueConfig[] parameters = config.getParameters();
            String[] types = Configurator.getTypes(parameters);
            method = beanInfo.findMethod(methodName, types);
            params = parameters;
        }
        MethodJoinpoint joinpoint = new MethodJoinpoint(method);
        joinpoint.setTarget((Value<Object>)new ImmediateValue(bean));
        joinpoint.setParameters(params);
        return joinpoint;
    }

    private static void configure(BeanInfo beanInfo, Module module, Object bean, PropertyConfig pc, boolean nullify) throws Throwable {
        ValueConfig value = pc.getValue();
        Class clazz = null;
        String type = pc.getType();
        if (type == null) {
            type = value.getType();
        }
        if (type != null) {
            clazz = module.getClassLoader().loadClass(type);
        }
        Method setter = beanInfo.getSetter(pc.getPropertyName(), clazz);
        MethodJoinpoint joinpoint = new MethodJoinpoint(setter);
        ValueConfig param = !nullify ? value : null;
        joinpoint.setParameters(new ValueConfig[]{param});
        joinpoint.setTarget((Value<Object>)new ImmediateValue(bean));
        joinpoint.dispatch();
    }
}

