/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.identity.federation.bindings.wildfly.idp.UndertowRoleGenerator;
import org.picketlink.identity.federation.core.impl.EmptyRoleGenerator;

public enum RoleGeneratorTypeEnum {
    UNDERTOW_ROLE_GENERATOR("UndertowRoleGenerator", UndertowRoleGenerator.class.getName()),
    EMPTY_ROLE_GENERATOR("EmptyRoleGenerator", EmptyRoleGenerator.class.getName());

    private static final Map<String, RoleGeneratorTypeEnum> types;
    private final String alias;
    private final String type;

    private RoleGeneratorTypeEnum(String alias, String type) {
        this.alias = alias;
        this.type = type;
    }

    static String forType(String alias) {
        RoleGeneratorTypeEnum resolvedType = types.get(alias);
        if (resolvedType != null) {
            return resolvedType.getType();
        }
        return null;
    }

    public String toString() {
        return this.alias;
    }

    String getAlias() {
        return this.alias;
    }

    String getType() {
        return this.type;
    }

    static {
        types = new HashMap<String, RoleGeneratorTypeEnum>();
        for (RoleGeneratorTypeEnum element : RoleGeneratorTypeEnum.values()) {
            types.put(element.getAlias(), element);
        }
    }
}

