/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignatureProperty;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSignatureProperties
extends BaseStructure
implements SignatureProperties {
    private final String id;
    private final List<SignatureProperty> properties;

    public DOMSignatureProperties(List<DOMSignatureProperty> properties, String id) {
        if (properties == null) {
            throw new NullPointerException("properties cannot be null");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("properties cannot be empty");
        }
        this.properties = Collections.unmodifiableList(new ArrayList<DOMSignatureProperty>(properties));
        int size = this.properties.size();
        for (int i = 0; i < size; ++i) {
            if (this.properties.get(i) instanceof SignatureProperty) continue;
            throw new ClassCastException("properties[" + i + "] is not a valid type");
        }
        this.id = id;
    }

    public DOMSignatureProperties(Element propsElem) throws MarshalException {
        this.id = DOMUtils.getIdAttributeValue(propsElem, "Id");
        ArrayList<DOMSignatureProperty> properties = new ArrayList<DOMSignatureProperty>();
        for (Node firstChild = propsElem.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
            if (firstChild.getNodeType() != 1) continue;
            String name = firstChild.getLocalName();
            String namespace = firstChild.getNamespaceURI();
            if (!name.equals("SignatureProperty") || !"http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                throw new MarshalException("Invalid element name: " + namespace + ":" + name + ", expected SignatureProperty");
            }
            properties.add(new DOMSignatureProperty((Element)firstChild));
        }
        if (properties.isEmpty()) {
            throw new MarshalException("properties cannot be empty");
        }
        this.properties = Collections.unmodifiableList(properties);
    }

    @Override
    public List<SignatureProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public static void marshal(XmlWriter xwriter, SignatureProperties sigProps, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        xwriter.writeStartElement(dsPrefix, "SignatureProperties", "http://www.w3.org/2000/09/xmldsig#");
        xwriter.writeIdAttribute("", "", "Id", sigProps.getId());
        List<SignatureProperty> properties = sigProps.getProperties();
        for (SignatureProperty property : properties) {
            DOMSignatureProperty.marshal(xwriter, property, dsPrefix, context);
        }
        xwriter.writeEndElement();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureProperties)) {
            return false;
        }
        SignatureProperties osp = (SignatureProperties)o;
        boolean idsEqual = this.id == null ? osp.getId() == null : this.id.equals(osp.getId());
        return ((Object)this.properties).equals(osp.getProperties()) && idsEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + ((Object)this.properties).hashCode();
        return result;
    }
}

