/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.query.dsl.impl.AbstractFacet;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.facet.Facet;

public class DiscreteFacetRequest
extends FacetingRequestImpl {
    DiscreteFacetRequest(String name, String fieldName) {
        super(name, fieldName);
    }

    @Override
    public Class<?> getFacetValueType() {
        return String[].class;
    }

    @Override
    public Facet createFacet(String value, int count) {
        return new SimpleFacet(this.getFacetingName(), this.getFieldName(), value, count);
    }

    static class SimpleFacet
    extends AbstractFacet {
        SimpleFacet(String facetingName, String fieldName, String value, int count) {
            super(facetingName, fieldName, value, count);
        }

        @Override
        public Query getFacetQuery() {
            return new TermQuery(new Term(this.getFieldName(), this.getValue()));
        }
    }
}

