/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.ProjectionConverter;
import org.infinispan.query.impl.QueryResultLoader;

public class ProjectionLoader
implements QueryResultLoader {
    private final ProjectionConverter projectionConverter;
    private final EntityLoader entityLoader;

    public ProjectionLoader(ProjectionConverter projectionConverter, EntityLoader entityLoader) {
        this.projectionConverter = projectionConverter;
        this.entityLoader = entityLoader;
    }

    @Override
    public List<Object> load(List<EntityInfo> entityInfos) {
        ArrayList<Object> list = new ArrayList<Object>(entityInfos.size());
        for (EntityInfo entityInfo : entityInfos) {
            list.add(this.load(entityInfo));
        }
        return list;
    }

    public Object[] load(EntityInfo entityInfo) {
        Object[] projection = entityInfo.getProjection();
        if (entityInfo.isProjectThis()) {
            entityInfo.populateWithEntityInstance(this.entityLoader.load(entityInfo));
        }
        return this.projectionConverter.convert(projection);
    }
}

