/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.BadServerDefinition;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryHelper;
import com.sun.corba.se.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.se.spi.activation.ServerAlreadyActive;
import com.sun.corba.se.spi.activation.ServerAlreadyRegistered;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class RegisterServer
implements CommandHandler {
    RegisterServer() {
    }

    @Override
    public String getCommandName() {
        return "register";
    }

    @Override
    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println(CorbaResourceUtil.getText("servertool.register"));
        } else {
            out.println(CorbaResourceUtil.getText("servertool.register1"));
        }
    }

    @Override
    public boolean processCommand(String[] cmdArgs, ORB orb, PrintStream out) {
        int i = 0;
        String applicationName = "";
        String name = "";
        String classpath = "";
        String args = "";
        String vmargs = "";
        int serverId = 0;
        while (i < cmdArgs.length) {
            String arg;
            if ((arg = cmdArgs[i++]).equals("-server")) {
                if (i < cmdArgs.length) {
                    name = cmdArgs[i++];
                    continue;
                }
                return true;
            }
            if (arg.equals("-applicationName")) {
                if (i < cmdArgs.length) {
                    applicationName = cmdArgs[i++];
                    continue;
                }
                return true;
            }
            if (arg.equals("-classpath")) {
                if (i < cmdArgs.length) {
                    classpath = cmdArgs[i++];
                    continue;
                }
                return true;
            }
            if (arg.equals("-args")) {
                while (i < cmdArgs.length && !cmdArgs[i].equals("-vmargs")) {
                    args = args.equals("") ? cmdArgs[i] : args + " " + cmdArgs[i];
                    ++i;
                }
                if (!args.equals("")) continue;
                return true;
            }
            if (arg.equals("-vmargs")) {
                while (i < cmdArgs.length && !cmdArgs[i].equals("-args")) {
                    vmargs = vmargs.equals("") ? cmdArgs[i] : vmargs + " " + cmdArgs[i];
                    ++i;
                }
                if (!vmargs.equals("")) continue;
                return true;
            }
            return true;
        }
        if (name.equals("")) {
            return true;
        }
        try {
            Repository repository = RepositoryHelper.narrow(orb.resolve_initial_references("ServerRepository"));
            ServerDef server = new ServerDef(applicationName, name, classpath, args, vmargs);
            serverId = repository.registerServer(server);
            Activator activator = ActivatorHelper.narrow(orb.resolve_initial_references("ServerActivator"));
            activator.activate(serverId);
            activator.install(serverId);
            out.println(CorbaResourceUtil.getText("servertool.register2", serverId));
        }
        catch (ServerNotRegistered ex) {
        }
        catch (ServerAlreadyActive ex) {
        }
        catch (ServerHeldDown ex) {
            out.println(CorbaResourceUtil.getText("servertool.register3", serverId));
        }
        catch (ServerAlreadyRegistered ex) {
            out.println(CorbaResourceUtil.getText("servertool.register4", serverId));
        }
        catch (BadServerDefinition ex) {
            out.println(CorbaResourceUtil.getText("servertool.baddef", ex.reason));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

