/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.jboss.as.clustering.infinispan.BatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;

public class DefaultCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private static final ThreadLocal<Batch> CURRENT_BATCH = new ThreadLocal();
    private final EmbeddedCacheManager manager;
    private final Batcher<? extends Batch> batcher;
    private final boolean sync;
    private final Set<Flag> flags;

    DefaultCache(final EmbeddedCacheManager manager, final Batcher<? extends Batch> batcher, AdvancedCache<K, V> cache, final Set<Flag> flags) {
        super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

            public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                return new DefaultCache(manager, (Batcher<? extends Batch>)batcher, cache, flags);
            }
        });
        this.manager = manager;
        this.batcher = batcher;
        this.flags = flags;
        this.sync = cache.getCacheConfiguration().clustering().cacheMode().isSynchronous();
    }

    public DefaultCache(EmbeddedCacheManager manager, BatcherFactory batcherFactory, AdvancedCache<K, V> cache) {
        this(manager, batcherFactory.createBatcher((Cache<?, ?>)cache), cache, EnumSet.noneOf(Flag.class));
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public boolean startBatch() {
        if (this.batcher == null) {
            return false;
        }
        Batch batch = CURRENT_BATCH.get();
        if (batch != null) {
            return false;
        }
        CURRENT_BATCH.set(this.batcher.createBatch());
        return true;
    }

    public void endBatch(boolean successful) {
        Batch batch = CURRENT_BATCH.get();
        if (batch != null) {
            try {
                if (successful) {
                    batch.close();
                } else {
                    batch.discard();
                }
            }
            finally {
                CURRENT_BATCH.remove();
            }
        }
    }

    public void removeListener(Object listener) {
        if (listener.getClass().isAnnotationPresent(Listener.class)) {
            super.removeListener(listener);
        }
    }

    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        EnumSet<Flag> set = EnumSet.copyOf(this.flags);
        set.addAll(Arrays.asList(flags));
        return new DefaultCache<K, V>(this.manager, this.batcher, this.cache.withFlags(flags), set);
    }

    public void clear() {
        if (this.sync) {
            this.cache.clear();
        } else {
            this.cache.clearAsync();
        }
    }

    public V get(Object key) {
        return (V)super.get(key);
    }

    public V put(K key, V value) {
        Object result = null;
        if (this.sync || !this.flags.contains(Flag.IGNORE_RETURN_VALUES)) {
            result = this.cache.put(key, value);
        } else {
            this.cache.putAsync(key, value);
        }
        return (V)result;
    }

    public V put(K key, V value, Metadata metadata) {
        Object result = null;
        if (this.sync) {
            result = this.cache.put(key, value, metadata);
        } else {
            this.cache.putAsync(key, value, metadata);
        }
        return (V)result;
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Object result = null;
        if (this.sync) {
            result = this.cache.put(key, value, lifespan, unit);
        } else {
            this.cache.putAsync(key, value, lifespan, unit);
        }
        return (V)result;
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Object result = null;
        if (this.sync) {
            result = this.cache.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        } else {
            this.cache.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
        return (V)result;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.sync) {
            this.cache.putAll(map);
        } else {
            this.cache.putAllAsync(map);
        }
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        if (this.sync) {
            this.cache.putAll(map, lifespan, unit);
        } else {
            this.cache.putAllAsync(map, lifespan, unit);
        }
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (this.sync) {
            this.cache.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        } else {
            this.cache.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
    }

    public V remove(Object key) {
        Object result = null;
        if (this.sync) {
            result = this.cache.remove(key);
        } else {
            this.cache.removeAsync(key);
        }
        return (V)result;
    }

    public boolean remove(Object key, Object value) {
        boolean result = false;
        if (this.sync) {
            result = this.cache.remove(key, value);
        } else {
            this.cache.removeAsync(key, value);
        }
        return result;
    }

    public V replace(K key, V value) {
        Object result = null;
        if (this.sync) {
            result = this.cache.replace(key, value);
        } else {
            this.cache.replaceAsync(key, value);
        }
        return (V)result;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        boolean result = false;
        if (this.sync) {
            result = this.cache.replace(key, oldValue, newValue);
        } else {
            this.cache.replaceAsync(key, oldValue, newValue);
        }
        return result;
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        Object result = null;
        if (this.sync) {
            result = this.cache.replace(key, value, lifespan, unit);
        } else {
            this.cache.replaceAsync(key, value, lifespan, unit);
        }
        return (V)result;
    }

    public boolean replace(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        boolean result = false;
        if (this.sync) {
            result = this.cache.replace(key, oldValue, newValue, lifespan, unit);
        } else {
            this.cache.replaceAsync(key, oldValue, newValue, lifespan, unit);
        }
        return result;
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Object result = null;
        if (this.sync) {
            result = this.cache.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        } else {
            this.cache.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
        return (V)result;
    }

    public boolean replace(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        boolean result = false;
        if (this.sync) {
            result = this.cache.replace(key, oldValue, newValue, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        } else {
            this.cache.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
        return result;
    }

    public boolean equals(Object object) {
        return object == this || object == this.cache;
    }

    public int hashCode() {
        return this.cache.hashCode();
    }
}

