/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilder;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilderFactory;
import org.wildfly.clustering.service.Builder;

public class CacheConfigurationBuilder
implements ResourceServiceBuilder<Configuration>,
ConfigurationBuilderFactory {
    private final InjectedValue<EvictionConfiguration> eviction = new InjectedValue();
    private final InjectedValue<ExpirationConfiguration> expiration = new InjectedValue();
    private final InjectedValue<IndexingConfiguration> indexing = new InjectedValue();
    private final InjectedValue<LockingConfiguration> locking = new InjectedValue();
    private final InjectedValue<PersistenceConfiguration> persistence = new InjectedValue();
    private final InjectedValue<TransactionConfiguration> transaction = new InjectedValue();
    private final InjectedValue<GlobalConfiguration> global = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile JMXStatisticsConfiguration statistics;
    private volatile ModuleIdentifier module;

    CacheConfigurationBuilder(String containerName, String cacheName) {
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return CacheServiceName.CONFIGURATION.getServiceName(this.containerName, this.cacheName);
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return new ConfigurationBuilder(this.containerName, this.cacheName, (ConfigurationBuilderFactory)this).build(target).addDependency(CacheComponent.EVICTION.getServiceName(this.containerName, this.cacheName), EvictionConfiguration.class, this.eviction).addDependency(CacheComponent.EXPIRATION.getServiceName(this.containerName, this.cacheName), ExpirationConfiguration.class, this.expiration).addDependency(CacheComponent.INDEXING.getServiceName(this.containerName, this.cacheName), IndexingConfiguration.class, this.indexing).addDependency(CacheComponent.LOCKING.getServiceName(this.containerName, this.cacheName), LockingConfiguration.class, this.locking).addDependency(CacheComponent.PERSISTENCE.getServiceName(this.containerName, this.cacheName), PersistenceConfiguration.class, this.persistence).addDependency(CacheComponent.TRANSACTION.getServiceName(this.containerName, this.cacheName), TransactionConfiguration.class, this.transaction).addDependency(CacheContainerServiceName.CONFIGURATION.getServiceName(this.containerName), GlobalConfiguration.class, this.global).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader);
    }

    public Builder<Configuration> configure(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        this.module = ModelNodes.asModuleIdentifier((ModelNode)CacheResourceDefinition.Attribute.MODULE.getDefinition().resolveModelAttribute(resolver, model));
        this.statistics = new org.infinispan.configuration.cache.ConfigurationBuilder().jmxStatistics().enabled(CacheResourceDefinition.Attribute.STATISTICS_ENABLED.getDefinition().resolveModelAttribute(resolver, model).asBoolean()).create();
        return this;
    }

    public org.infinispan.configuration.cache.ConfigurationBuilder createConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        EvictionConfiguration eviction = (EvictionConfiguration)this.eviction.getValue();
        ExpirationConfiguration expiration = (ExpirationConfiguration)this.expiration.getValue();
        IndexingConfiguration indexing = (IndexingConfiguration)this.indexing.getValue();
        LockingConfiguration locking = (LockingConfiguration)this.locking.getValue();
        PersistenceConfiguration persistence = (PersistenceConfiguration)this.persistence.getValue();
        TransactionConfiguration transaction = (TransactionConfiguration)this.transaction.getValue();
        builder.eviction().read(eviction);
        builder.expiration().read(expiration);
        builder.indexing().read(indexing);
        builder.locking().read(locking);
        builder.persistence().read(persistence);
        builder.transaction().read(transaction);
        builder.jmxStatistics().read(this.statistics);
        return builder;
    }

    ClassLoader getClassLoader() {
        if (this.module != null) {
            try {
                return ((ModuleLoader)this.loader.getValue()).loadModule(this.module).getClassLoader();
            }
            catch (ModuleLoadException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return ((GlobalConfiguration)this.global.getValue()).classLoader();
    }
}

