/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Set;
import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.transform.SimpleAttributeConverter;
import org.jboss.as.clustering.controller.transform.SimpleRejectAttributeChecker;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JGroupsTransportResourceDefinition
extends TransportResourceDefinition {
    static final PathElement LEGACY_PATH = JGroupsTransportResourceDefinition.pathElement("TRANSPORT");
    static final PathElement PATH = JGroupsTransportResourceDefinition.pathElement("jgroups");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder;
        ResourceTransformationDescriptionBuilder resourceTransformationDescriptionBuilder = builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH) : parent.addChildResource(PATH);
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            SimpleRejectAttributeChecker.Rejecter stackRejecter = new SimpleRejectAttributeChecker.Rejecter(){

                public boolean reject(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    ModelNode defaultChannel;
                    if (value.isDefined()) {
                        return false;
                    }
                    PathAddress rootAddress = address.subAddress(0, address.size() - 3);
                    PathAddress subsystemAddress = rootAddress.append(new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
                    ModelNode subsystemModel = context.readResourceFromRoot(subsystemAddress).getModel();
                    String channelName = null;
                    if (model.hasDefined(Attribute.CHANNEL.getDefinition().getName())) {
                        ModelNode channel = model.get(Attribute.CHANNEL.getDefinition().getName());
                        if (channel.getType() == ModelType.STRING) {
                            channelName = channel.asString();
                        }
                    } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName()) && (defaultChannel = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName())).getType() == ModelType.STRING) {
                        channelName = defaultChannel.asString();
                    }
                    if (channelName == null) {
                        return true;
                    }
                    String stackName = null;
                    PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement((String)channelName)});
                    try {
                        ModelNode defaultStack;
                        ModelNode channel = context.readResourceFromRoot(channelAddress).getModel();
                        if (channel.hasDefined(ChannelResourceDefinition.STACK.getName())) {
                            ModelNode stack = channel.get(ChannelResourceDefinition.STACK.getName());
                            if (stack.getType() == ModelType.STRING) {
                                stackName = stack.asString();
                            }
                        } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName()) && (defaultStack = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName())).getType() == ModelType.STRING) {
                            stackName = defaultStack.asString();
                        }
                    }
                    catch (Resource.NoSuchResourceException e) {
                        // empty catch block
                    }
                    return stackName == null;
                }

                public String getRejectedMessage(Set<String> attributes) {
                    return InfinispanLogger.ROOT_LOGGER.indeterminiteStack();
                }
            };
            SimpleAttributeConverter.Converter stackConverter = new SimpleAttributeConverter.Converter(){

                public void convert(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    if (!value.isDefined()) {
                        ModelNode defaultChannel;
                        PathAddress rootAddress = address.subAddress(0, address.size() - 3);
                        PathAddress subsystemAddress = rootAddress.append(new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
                        ModelNode subsystemModel = context.readResourceFromRoot(subsystemAddress).getModel();
                        String channelName = null;
                        if (model.hasDefined(Attribute.CHANNEL.getDefinition().getName())) {
                            ModelNode channel = model.get(Attribute.CHANNEL.getDefinition().getName());
                            if (channel.getType() == ModelType.STRING) {
                                channelName = channel.asString();
                            }
                        } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName()) && (defaultChannel = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.getName())).getType() == ModelType.STRING) {
                            channelName = defaultChannel.asString();
                        }
                        if (channelName != null) {
                            PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement((String)channelName)});
                            try {
                                ModelNode defaultStack;
                                ModelNode channel = context.readResourceFromRoot(channelAddress).getModel();
                                if (channel.hasDefined(ChannelResourceDefinition.STACK.getName())) {
                                    ModelNode stack = channel.get(ChannelResourceDefinition.STACK.getName());
                                    if (stack.getType() == ModelType.STRING) {
                                        value.set(stack.asString());
                                    }
                                } else if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName()) && (defaultStack = subsystemModel.get(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName())).getType() == ModelType.STRING) {
                                    value.set(defaultStack.asString());
                                }
                            }
                            catch (Resource.NoSuchResourceException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new SimpleRejectAttributeChecker(stackRejecter), new AttributeDefinition[]{Attribute.STACK.getDefinition()})).setValueConverter((AttributeConverter)new SimpleAttributeConverter(stackConverter), new AttributeDefinition[]{Attribute.STACK.getDefinition()})).addRename(Attribute.CHANNEL.getDefinition(), Attribute.CLUSTER.getDefinition().getName())).end();
        }
    }

    JGroupsTransportResourceDefinition() {
        super(PATH);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        JGroupsTransportServiceHandler handler = new JGroupsTransportServiceHandler();
        new AddStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler).addAttributes(Attribute.class).register(registration);
        new RemoveStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler).register(registration);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        new ReloadRequiredWriteAttributeHandler(Attribute.class).register(registration);
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry(registration.registerSubModel((ResourceDefinition)this)));
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        CHANNEL("channel", ModelType.STRING, null),
        CLUSTER("cluster", ModelType.STRING, null, InfinispanModel.VERSION_3_0_0),
        EXECUTOR("executor", ModelType.STRING, null),
        LOCK_TIMEOUT("lock-timeout", ModelType.LONG, new ModelNode(240000L)),
        STACK("stack", ModelType.STRING, null, InfinispanModel.VERSION_3_0_0);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = Attribute.createBuilder(name, type, defaultValue).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue, InfinispanModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type, defaultValue).setDeprecated(deprecation.getVersion())).build();
        }

        private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue) {
            return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null));
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

