/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MixedKeyedJDBCStoreResourceDefinition
extends JDBCStoreResourceDefinition {
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)"mixed-keyed-jdbc-store", (String)"MIXED_KEYED_JDBC_STORE");
    static final PathElement PATH = MixedKeyedJDBCStoreResourceDefinition.pathElement("mixed-jdbc");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH) : parent.addChildResource(PATH);
        JDBCStoreResourceDefinition.buildTransformation(version, builder);
        BinaryTableResourceDefinition.buildTransformation(version, builder);
        StringTableResourceDefinition.buildTransformation(version, builder);
    }

    MixedKeyedJDBCStoreResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(PATH, new InfinispanResourceDescriptionResolver(PATH, MixedKeyedJDBCStoreResourceDefinition.pathElement("jdbc"), WILDCARD_PATH), allowRuntimeOnlyRegistration);
    }

    public void registerOperations(final ManagementResourceRegistration registration) {
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new MixedKeyedJDBCStoreBuilderFactory());
        new AddStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                super.execute(context, operation);
                this.addTableStep(context, operation, Attribute.BINARY_TABLE, BinaryTableResourceDefinition.PATH, new BinaryTableBuilderFactory());
                this.addTableStep(context, operation, Attribute.STRING_TABLE, StringTableResourceDefinition.PATH, new StringTableBuilderFactory());
            }

            private void addTableStep(OperationContext context, ModelNode operation, Attribute attribute, PathElement path, ResourceServiceBuilderFactory<TableManipulationConfiguration> provider) {
                if (operation.hasDefined(attribute.getDefinition().getName())) {
                    ModelNode addTableOperation = Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{path}));
                    ModelNode parameters = operation.get(attribute.getDefinition().getName());
                    for (Property parameter : parameters.asPropertyList()) {
                        addTableOperation.get(parameter.getName()).set(parameter.getValue());
                    }
                    context.addStep(addTableOperation, registration.getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{path}), "add"), context.getCurrentStage());
                }
            }
        }.addAttributes(JDBCStoreResourceDefinition.Attribute.class).addAttributes(StoreResourceDefinition.Attribute.class).register(registration);
        new RemoveStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler).register(registration);
    }

    @Override
    public void registerChildren(ManagementResourceRegistration registration) {
        super.registerChildren(registration);
        new BinaryTableResourceDefinition().register(registration);
        new StringTableResourceDefinition().register(registration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        registration.registerReadWriteAttribute(Attribute.BINARY_TABLE.getDefinition(), BinaryKeyedJDBCStoreResourceDefinition.LEGACY_READ_TABLE_HANDLER, BinaryKeyedJDBCStoreResourceDefinition.LEGACY_WRITE_TABLE_HANDLER);
        registration.registerReadWriteAttribute(Attribute.STRING_TABLE.getDefinition(), StringKeyedJDBCStoreResourceDefinition.LEGACY_READ_TABLE_HANDLER, StringKeyedJDBCStoreResourceDefinition.LEGACY_WRITE_TABLE_HANDLER);
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry(registration.registerSubModel((ResourceDefinition)this)));
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        BINARY_TABLE(BinaryKeyedJDBCStoreResourceDefinition.Attribute.TABLE),
        STRING_TABLE(StringKeyedJDBCStoreResourceDefinition.Attribute.TABLE);

        private final AttributeDefinition definition;

        private Attribute(org.jboss.as.clustering.controller.Attribute attribute) {
            this.definition = (AttributeDefinition)attribute.getDefinition();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

