/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.controller.AttributeMarshallers;
import org.jboss.as.clustering.controller.AttributeParsers;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.StoreMetric;
import org.jboss.as.clustering.infinispan.subsystem.StoreMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteThroughResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class StoreResourceDefinition
extends SimpleResourceDefinition
implements Registration {
    static final PathElement WILDCARD_PATH = StoreResourceDefinition.pathElement("*");
    private final boolean allowRuntimeOnlyRegistration;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"store", (String)value);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            builder.discardChildResource(StoreWriteThroughResourceDefinition.PATH);
        } else {
            StoreWriteThroughResourceDefinition.buildTransformation(version, builder);
        }
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            org.jboss.as.clustering.controller.transform.OperationTransformer putPropertyTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.PROPERTIES.getDefinition().getName().equals(attributeName)) {
                        String key = operation.get("key").asString();
                        ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        ModelNode transformedOperation = Util.createAddOperation((PathAddress)address.append(new PathElement[]{StorePropertyResourceDefinition.pathElement(key)}));
                        transformedOperation.get(StorePropertyResourceDefinition.VALUE.getName()).set(value);
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(MapOperations.MAP_PUT_DEFINITION.getName(), (OperationTransformer)new SimpleOperationTransformer(putPropertyTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer removePropertyTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.PROPERTIES.getDefinition().getName().equals(attributeName)) {
                        String key = operation.get("key").asString();
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        return Util.createRemoveOperation((PathAddress)address.append(new PathElement[]{StorePropertyResourceDefinition.pathElement(key)}));
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(MapOperations.MAP_PUT_DEFINITION.getName(), (OperationTransformer)new SimpleOperationTransformer(removePropertyTransformer));
        }
        StoreWriteBehindResourceDefinition.buildTransformation(version, builder);
    }

    StoreResourceDefinition(PathElement path, ResourceDescriptionResolver resolver, boolean allowRuntimeOnlyRegistration) {
        super(path, resolver);
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        new ReloadRequiredWriteAttributeHandler(Attribute.class).register(registration);
        if (this.allowRuntimeOnlyRegistration) {
            new MetricHandler((MetricExecutor)new StoreMetricExecutor(), StoreMetric.class).register(registration);
        }
    }

    public void registerChildren(ManagementResourceRegistration registration) {
        new StoreWriteBehindResourceDefinition().register(registration);
        new StoreWriteThroughResourceDefinition().register(registration);
        new StorePropertyResourceDefinition().register(registration);
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        FETCH_STATE("fetch-state", true),
        PASSIVATION("passivation", true),
        PRELOAD("preload", false),
        PURGE("purge", true),
        SHARED("shared", false),
        SINGLETON("singleton", false),
        PROPERTIES("properties");

        private final AttributeDefinition definition;

        private Attribute(String name, boolean defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.BOOLEAN).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(new ModelNode(defaultValue))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        private Attribute(String name) {
            this.definition = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder(name, true).setAllowExpression(true)).setAttributeMarshaller(AttributeMarshallers.PROPERTY_LIST)).setAttributeParser(AttributeParsers.COLLECTION)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

