/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;

class AddressSettingsValidator {
    private static final String JMS_QUEUE_ADDRESS_PREFIX = "jms.queue.";
    private static final String JMS_TOPIC_ADDRESS_PREFIX = "jms.topic.";
    static OperationStepHandler ADD_VALIDATOR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String addressSetting = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            PathAddress hornetqServerAddress = context.getCurrentAddress().getParent();
            Resource hornetqServer = context.readResourceFromRoot(hornetqServerAddress, true);
            AddressSettingsValidator.checkExpiryAddress(context, operation, hornetqServer, addressSetting);
            AddressSettingsValidator.checkDeadLetterAddress(context, operation, hornetqServer, addressSetting);
        }
    };

    AddressSettingsValidator() {
    }

    private static void checkExpiryAddress(OperationContext context, ModelNode model, Resource hornetqServer, String addressSetting) throws OperationFailedException {
        ModelNode expiryAddress = CommonAttributes.EXPIRY_ADDRESS.resolveModelAttribute(context, model);
        if (!AddressSettingsValidator.findMatchingResource(expiryAddress, hornetqServer)) {
            MessagingLogger.ROOT_LOGGER.noMatchingExpiryAddress(expiryAddress.asString(), addressSetting);
        }
    }

    private static void checkDeadLetterAddress(OperationContext context, ModelNode model, Resource hornetqServer, String addressSetting) throws OperationFailedException {
        ModelNode deadLetterAddress = CommonAttributes.DEAD_LETTER_ADDRESS.resolveModelAttribute(context, model);
        if (!AddressSettingsValidator.findMatchingResource(deadLetterAddress, hornetqServer)) {
            MessagingLogger.ROOT_LOGGER.noMatchingDeadLetterAddress(deadLetterAddress.asString(), addressSetting);
        }
    }

    private static boolean findMatchingResource(ModelNode addressNode, Resource hornetqServer) {
        String addressPrefix;
        String childType;
        if (!addressNode.isDefined()) {
            return true;
        }
        String address = addressNode.asString();
        if (address.startsWith(JMS_QUEUE_ADDRESS_PREFIX)) {
            childType = "jms-queue";
            addressPrefix = JMS_QUEUE_ADDRESS_PREFIX;
        } else if (address.startsWith(JMS_TOPIC_ADDRESS_PREFIX)) {
            childType = "jms-topic";
            addressPrefix = JMS_TOPIC_ADDRESS_PREFIX;
        } else {
            childType = "core-queue";
            addressPrefix = "";
        }
        for (String childName : hornetqServer.getChildrenNames(childType)) {
            if (!address.equals(addressPrefix + childName)) continue;
            return true;
        }
        return false;
    }
}

