/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.reader;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.reader.MessageUtil;

public class StreamMessageUtil
extends MessageUtil {
    public static boolean streamReadBoolean(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 2: {
                return buff.readBoolean();
            }
            case 10: {
                String s = buff.readNullableString();
                return Boolean.valueOf(s);
            }
        }
        throw new IllegalStateException("Invalid conversion, type byte was " + type);
    }

    public static byte streamReadByte(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        int index = buff.readerIndex();
        try {
            byte type = buff.readByte();
            switch (type) {
                case 3: {
                    return buff.readByte();
                }
                case 10: {
                    String s = buff.readNullableString();
                    return Byte.parseByte(s);
                }
            }
            throw new IllegalStateException("Invalid conversion");
        }
        catch (NumberFormatException e) {
            buff.readerIndex(index);
            throw e;
        }
    }

    public static short streamReadShort(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 3: {
                return buff.readByte();
            }
            case 5: {
                return buff.readShort();
            }
            case 10: {
                String s = buff.readNullableString();
                return Short.parseShort(s);
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }

    public static char streamReadChar(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 11: {
                return (char)buff.readShort();
            }
            case 10: {
                String str = buff.readNullableString();
                if (str == null) {
                    throw new NullPointerException("Invalid conversion");
                }
                throw new IllegalStateException("Invalid conversion");
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }

    public static int streamReadInteger(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 3: {
                return buff.readByte();
            }
            case 5: {
                return buff.readShort();
            }
            case 6: {
                return buff.readInt();
            }
            case 10: {
                String s = buff.readNullableString();
                return Integer.parseInt(s);
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }

    public static long streamReadLong(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 3: {
                return buff.readByte();
            }
            case 5: {
                return buff.readShort();
            }
            case 6: {
                return buff.readInt();
            }
            case 7: {
                return buff.readLong();
            }
            case 10: {
                String s = buff.readNullableString();
                return Long.parseLong(s);
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }

    public static float streamReadFloat(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 8: {
                return Float.intBitsToFloat(buff.readInt());
            }
            case 10: {
                String s = buff.readNullableString();
                return Float.parseFloat(s);
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }

    public static double streamReadDouble(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 8: {
                return Float.intBitsToFloat(buff.readInt());
            }
            case 9: {
                return Double.longBitsToDouble(buff.readLong());
            }
            case 10: {
                String s = buff.readNullableString();
                return Double.parseDouble(s);
            }
        }
        throw new IllegalStateException("Invalid conversion: " + type);
    }

    public static String streamReadString(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 2: {
                return String.valueOf(buff.readBoolean());
            }
            case 3: {
                return String.valueOf(buff.readByte());
            }
            case 5: {
                return String.valueOf(buff.readShort());
            }
            case 11: {
                return String.valueOf((char)buff.readShort());
            }
            case 6: {
                return String.valueOf(buff.readInt());
            }
            case 7: {
                return String.valueOf(buff.readLong());
            }
            case 8: {
                return String.valueOf(Float.intBitsToFloat(buff.readInt()));
            }
            case 9: {
                return String.valueOf(Double.longBitsToDouble(buff.readLong()));
            }
            case 10: {
                return buff.readNullableString();
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }

    public static Pair<Integer, Integer> streamReadBytes(Message message, int remainingBytes, byte[] value) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        if (remainingBytes == -1) {
            return new Pair<Integer, Integer>(0, -1);
        }
        if (remainingBytes == 0) {
            byte type = buff.readByte();
            if (type != 4) {
                throw new IllegalStateException("Invalid conversion");
            }
            remainingBytes = buff.readInt();
        }
        int read = Math.min(value.length, remainingBytes);
        buff.readBytes(value, 0, read);
        if ((remainingBytes -= read) == 0) {
            remainingBytes = -1;
        }
        return new Pair<Integer, Integer>(remainingBytes, read);
    }

    public static Object streamReadObject(Message message) {
        ActiveMQBuffer buff = StreamMessageUtil.getBodyBuffer(message);
        byte type = buff.readByte();
        switch (type) {
            case 2: {
                return buff.readBoolean();
            }
            case 3: {
                return buff.readByte();
            }
            case 5: {
                return buff.readShort();
            }
            case 11: {
                return Character.valueOf((char)buff.readShort());
            }
            case 6: {
                return buff.readInt();
            }
            case 7: {
                return buff.readLong();
            }
            case 8: {
                return Float.valueOf(Float.intBitsToFloat(buff.readInt()));
            }
            case 9: {
                return Double.longBitsToDouble(buff.readLong());
            }
            case 10: {
                return buff.readNullableString();
            }
            case 4: {
                int bufferLen = buff.readInt();
                byte[] bytes = new byte[bufferLen];
                buff.readBytes(bytes);
                return bytes;
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }
}

