/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.recovery;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQRegistry;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQRegistryImpl;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;

public final class RecoveryManager {
    private ActiveMQRegistry registry;
    private static final String RESOURCE_RECOVERY_CLASS_NAMES = "org.jboss.as.messaging.jms.AS7RecoveryRegistry;org.jboss.as.integration.activemq.recovery.AS5RecoveryRegistry";
    private final Set<XARecoveryConfig> resources = new ConcurrentHashSet();

    public void start(boolean useAutoRecovery) {
        if (useAutoRecovery) {
            this.locateRecoveryRegistry();
        } else {
            this.registry = null;
        }
    }

    public XARecoveryConfig register(ActiveMQConnectionFactory factory, String userName, String password) {
        ActiveMQRALogger.LOGGER.debug("registering recovery for factory : " + factory);
        XARecoveryConfig config = XARecoveryConfig.newConfig((ActiveMQConnectionFactory)factory, (String)userName, (String)password);
        this.resources.add(config);
        if (this.registry != null) {
            this.registry.register(config);
        }
        return config;
    }

    public void unRegister(XARecoveryConfig resourceRecovery) {
        if (this.registry != null) {
            this.registry.unRegister(resourceRecovery);
        }
    }

    public void stop() {
        if (this.registry != null) {
            for (XARecoveryConfig recovery : this.resources) {
                this.registry.unRegister(recovery);
            }
            this.registry.stop();
        }
        this.resources.clear();
    }

    private void locateRecoveryRegistry() {
        String[] locatorClasses;
        for (String locatorClasse : locatorClasses = RESOURCE_RECOVERY_CLASS_NAMES.split(";")) {
            try {
                ServiceLoader<ActiveMQRegistry> sl = ServiceLoader.load(ActiveMQRegistry.class);
                this.registry = sl.iterator().hasNext() ? sl.iterator().next() : ActiveMQRegistryImpl.getInstance();
            }
            catch (Throwable e) {
                ActiveMQRALogger.LOGGER.debug("unable to load  recovery registry " + locatorClasse, e);
            }
            if (this.registry != null) break;
        }
        if (this.registry != null) {
            ActiveMQRALogger.LOGGER.debug("Recovery Registry located = " + this.registry);
        }
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    public Set<XARecoveryConfig> getResources() {
        return this.resources;
    }
}

