/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;

public class Database {
    private final Dialect dialect;
    private final MetadataBuildingOptions buildingOptions;
    private final JdbcEnvironment jdbcEnvironment;
    private Schema implicitSchema;
    private final Map<Schema.Name, Schema> schemaMap = new TreeMap<Schema.Name, Schema>();
    private List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects;
    private List<InitCommand> initCommands;

    public Database(MetadataBuildingOptions buildingOptions) {
        this(buildingOptions, buildingOptions.getServiceRegistry().getService(JdbcEnvironment.class));
    }

    public Database(MetadataBuildingOptions buildingOptions, JdbcEnvironment jdbcEnvironment) {
        this.buildingOptions = buildingOptions;
        this.jdbcEnvironment = jdbcEnvironment;
        this.dialect = Database.determineDialect(buildingOptions);
        this.implicitSchema = this.makeSchema(new Schema.Name(this.toIdentifier(buildingOptions.getMappingDefaults().getImplicitCatalogName()), this.toIdentifier(buildingOptions.getMappingDefaults().getImplicitSchemaName())));
    }

    private static Dialect determineDialect(MetadataBuildingOptions buildingOptions) {
        Dialect dialect = buildingOptions.getServiceRegistry().getService(JdbcServices.class).getDialect();
        if (dialect != null) {
            return dialect;
        }
        return new H2Dialect();
    }

    private Schema makeSchema(Schema.Name name) {
        Schema schema = new Schema(this, name);
        this.schemaMap.put(name, schema);
        return schema;
    }

    public MetadataBuildingOptions getBuildingOptions() {
        return this.buildingOptions;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    public Identifier toIdentifier(String text) {
        return text == null ? null : this.jdbcEnvironment.getIdentifierHelper().toIdentifier(text);
    }

    public PhysicalNamingStrategy getPhysicalNamingStrategy() {
        return this.getBuildingOptions().getPhysicalNamingStrategy();
    }

    public Iterable<Schema> getSchemas() {
        return this.schemaMap.values();
    }

    public Schema getDefaultSchema() {
        return this.implicitSchema;
    }

    public Schema locateSchema(Identifier catalogName, Identifier schemaName) {
        if (catalogName == null && schemaName == null) {
            return this.getDefaultSchema();
        }
        Schema.Name name = new Schema.Name(catalogName, schemaName);
        Schema schema = this.schemaMap.get(name);
        if (schema == null) {
            schema = this.makeSchema(name);
        }
        return schema;
    }

    public Schema adjustDefaultSchema(Identifier catalogName, Identifier schemaName) {
        Schema.Name name = new Schema.Name(catalogName, schemaName);
        if (this.implicitSchema.getName().equals(name)) {
            return this.implicitSchema;
        }
        Schema schema = this.schemaMap.get(name);
        if (schema == null) {
            schema = this.makeSchema(name);
        }
        this.implicitSchema = schema;
        return this.implicitSchema;
    }

    public Schema adjustDefaultSchema(String implicitCatalogName, String implicitSchemaName) {
        return this.adjustDefaultSchema(this.toIdentifier(implicitCatalogName), this.toIdentifier(implicitSchemaName));
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        if (this.auxiliaryDatabaseObjects == null) {
            this.auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();
        }
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public Collection<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjects() {
        return this.auxiliaryDatabaseObjects == null ? Collections.emptyList() : this.auxiliaryDatabaseObjects;
    }

    public Collection<InitCommand> getInitCommands() {
        return this.initCommands == null ? Collections.emptyList() : this.initCommands;
    }

    public void addInitCommand(InitCommand initCommand) {
        if (this.initCommands == null) {
            this.initCommands = new ArrayList<InitCommand>();
        }
        this.initCommands.add(initCommand);
    }
}

