/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.Target;

public class SchemaDropperImpl
implements SchemaDropper {
    public Iterable<String> generateDropCommands(MetadataImplementor metadata, boolean dropSchemas, Dialect dialect) {
        final ArrayList<String> commands = new ArrayList<String>();
        this.doDrop((Metadata)metadata, dropSchemas, dialect, new Target(){

            @Override
            public boolean acceptsImportScriptActions() {
                return true;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void accept(String action) {
                commands.add(action);
            }

            @Override
            public void release() {
            }
        });
        return commands;
    }

    @Override
    public void doDrop(Metadata metadata, boolean dropSchemas, List<Target> targets) throws SchemaManagementException {
        this.doDrop(metadata, dropSchemas, targets.toArray(new Target[targets.size()]));
    }

    @Override
    public void doDrop(Metadata metadata, boolean dropSchemas, Dialect dialect, List<Target> targets) throws SchemaManagementException {
        this.doDrop(metadata, dropSchemas, dialect, targets.toArray(new Target[targets.size()]));
    }

    @Override
    public void doDrop(Metadata metadata, boolean dropSchemas, Target ... targets) throws SchemaManagementException {
        this.doDrop(metadata, dropSchemas, metadata.getDatabase().getJdbcEnvironment().getDialect(), targets);
    }

    @Override
    public void doDrop(Metadata metadata, boolean dropSchemas, Dialect dialect, Target ... targets) throws SchemaManagementException {
        Database database = metadata.getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        for (Target target : targets) {
            target.prepare();
        }
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaDropperImpl.applySqlStrings(targets, dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, metadata));
        }
        for (Schema schema : database.getSchemas()) {
            this.applyConstraintDropping(targets, schema, metadata);
            for (Table table : schema.getTables()) {
                if (!table.isPhysicalTable()) continue;
                SchemaDropperImpl.checkExportIdentifier(table, exportIdentifiers);
                SchemaDropperImpl.applySqlStrings(targets, dialect.getTableExporter().getSqlDropStrings(table, metadata));
            }
            for (Sequence sequence : schema.getSequences()) {
                SchemaDropperImpl.checkExportIdentifier(sequence, exportIdentifiers);
                SchemaDropperImpl.applySqlStrings(targets, dialect.getSequenceExporter().getSqlDropStrings(sequence, metadata));
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaDropperImpl.applySqlStrings(targets, auxiliaryDatabaseObject.sqlDropStrings(jdbcEnvironment.getDialect()));
        }
        for (Schema schema : database.getSchemas()) {
            if (!dropSchemas || schema.getName().getSchema() == null) continue;
            SchemaDropperImpl.applySqlStrings(targets, dialect.getDropSchemaCommand(schema.getName().getSchema().render(dialect)));
        }
        for (Iterator<Object> iterator : targets) {
            iterator.release();
        }
    }

    private void applyConstraintDropping(Target[] targets, Schema schema, Metadata metadata) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        if (!dialect.dropConstraints()) {
            return;
        }
        for (Table table : schema.getTables()) {
            if (!table.isPhysicalTable()) continue;
            Iterator fks = table.getForeignKeyIterator();
            while (fks.hasNext()) {
                ForeignKey foreignKey = (ForeignKey)fks.next();
                SchemaDropperImpl.applySqlStrings(targets, dialect.getForeignKeyExporter().getSqlDropStrings(foreignKey, metadata));
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(Target[] targets, String ... sqlStrings) {
        if (sqlStrings == null) {
            return;
        }
        for (Target target : targets) {
            for (String sqlString : sqlStrings) {
                target.accept(sqlString);
            }
        }
    }
}

