/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.api.configuration;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.xml.ws.BindingProvider;
import org.jboss.ws.api.configuration.ClientConfigurer;

public abstract class ClientConfigUtil {
    public static void setConfigHandlers(BindingProvider bp, String configFile, String configName) {
        ClientConfigurer configurer = ClientConfigUtil.resolveClientConfigurer();
        configurer.setConfigHandlers(bp, configFile, configName);
    }

    public static void setConfigProperties(Object proxy, String configFile, String configName) {
        ClientConfigurer configurer = ClientConfigUtil.resolveClientConfigurer();
        configurer.setConfigProperties(proxy, configFile, configName);
    }

    public static ClientConfigurer resolveClientConfigurer() {
        Iterator<ClientConfigurer> it = ServiceLoader.load(ClientConfigurer.class, ClientConfigUtil.getContextClassLoader()).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return (ClientConfigurer)org.jboss.ws.api.util.ServiceLoader.loadService(ClientConfigurer.class.getName(), "org.jboss.ws.common.configuration.ConfigHelper", ClientConfigUtil.class.getClassLoader());
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

