/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.notifications.cachelistener.BaseQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.util.KeyValuePair;

class QueueingAllSegmentListener<K, V>
extends BaseQueueingSegmentListener<K, V, Event<K, V>> {
    protected final Queue<KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>>> queue = new ConcurrentLinkedQueue<KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>>>();
    protected final InternalEntryFactory entryFactory;

    QueueingAllSegmentListener(InternalEntryFactory entryFactory) {
        this.entryFactory = entryFactory;
    }

    @Override
    public boolean handleEvent(Event<K, V> event, ListenerInvocation<Event<K, V>> invocation) {
        boolean queued;
        boolean bl = queued = !this.completed.get();
        if (queued) {
            CacheEntryEvent cacheEvent;
            InternalCacheEntry cacheEntry;
            boolean continueQueueing = true;
            if (event instanceof CacheEntryEvent && this.addEvent((cacheEntry = this.entryFactory.create((cacheEvent = (CacheEntryEvent)event).getKey(), cacheEvent.getValue(), cacheEvent.getMetadata())).getKey(), cacheEntry.getValue() != null ? cacheEntry : REMOVED)) {
                continueQueueing = false;
            }
            if (continueQueueing) {
                KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>> eventPair = new KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>>(event, invocation);
                this.queue.add(eventPair);
                if (this.completed.get() && this.queue.remove(eventPair)) {
                    invocation.invoke(event);
                }
            }
        }
        return queued;
    }

    @Override
    public void transferComplete() {
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            KeyValuePair eventPair = (KeyValuePair)iterator.next();
            ((ListenerInvocation)eventPair.getValue()).invoke(eventPair.getKey());
            iterator.remove();
        }
        this.completed.set(true);
    }
}

