/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemRootDefinition;
import org.jboss.as.connector.subsystems.datasources.DsParser;
import org.jboss.as.connector.subsystems.datasources.Element;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DataSourcesExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "datasources";
    private static final String RESOURCE_NAME = DataSourcesExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)3, (int)0, (int)0);

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, DataSourcesExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Initializing Datasources Extension", new Object[0]);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)DataSourcesSubsystemRootDefinition.createInstance(registerRuntimeOnly));
        subsystem.registerXMLElementWriter((XMLElementWriter)DataSourceSubsystemParser.INSTANCE);
        if (registerRuntimeOnly) {
            subsystem.registerDeploymentModel((ResourceDefinition)DataSourcesSubsystemRootDefinition.createDeployedInstance(registerRuntimeOnly));
        }
        if (context.isRegisterTransformers()) {
            DataSourcesSubsystemRootDefinition.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_1_1.getUriString(), (XMLElementReader)DataSourceSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_1_2.getUriString(), (XMLElementReader)DataSourceSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_2_0.getUriString(), (XMLElementReader)DataSourceSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_3_0.getUriString(), (XMLElementReader)DataSourceSubsystemParser.INSTANCE);
    }

    public static final class DataSourceSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final DataSourceSubsystemParser INSTANCE = new DataSourceSubsystemParser();

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            writer.writeStartElement(DataSourcesExtension.SUBSYSTEM_NAME);
            if (node.hasDefined("data-source") || node.hasDefined("xa-data-source")) {
                boolean isXADataSource = false;
                if (node.hasDefined("data-source")) {
                    this.writeDS(writer, false, node.get("data-source").asPropertyList());
                }
                if (node.hasDefined("xa-data-source")) {
                    this.writeDS(writer, true, node.get("xa-data-source").asPropertyList());
                }
            }
            if (node.hasDefined("jdbc-driver")) {
                writer.writeStartElement(DataSources.Tag.DRIVERS.getLocalName());
                for (Property driverProperty : node.get("jdbc-driver").asPropertyList()) {
                    writer.writeStartElement(DataSources.Tag.DRIVER.getLocalName());
                    writer.writeAttribute(Driver.Attribute.NAME.getLocalName(), driverProperty.getValue().require(Constants.DRIVER_NAME.getName()).asString());
                    if (this.has(driverProperty.getValue(), Constants.DRIVER_MODULE_NAME.getName())) {
                        String moduleName = driverProperty.getValue().get(Constants.DRIVER_MODULE_NAME.getName()).asString();
                        if (this.has(driverProperty.getValue(), Constants.MODULE_SLOT.getName())) {
                            moduleName = moduleName + ":" + driverProperty.getValue().get(Constants.MODULE_SLOT.getName()).asString();
                        }
                        writer.writeAttribute(Driver.Attribute.MODULE.getLocalName(), moduleName);
                    }
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MAJOR_VERSION, Constants.DRIVER_MAJOR_VERSION.getName());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MINOR_VERSION, Constants.DRIVER_MINOR_VERSION.getName());
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.DRIVER_CLASS.getLocalName(), Constants.DRIVER_CLASS_NAME.getName());
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.XA_DATASOURCE_CLASS.getLocalName(), Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName());
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.DATASOURCE_CLASS.getLocalName(), Constants.DRIVER_DATASOURCE_CLASS_NAME.getName());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeDS(XMLExtendedStreamWriter writer, boolean isXADataSource, List<Property> propertyList) throws XMLStreamException {
            for (Property property : propertyList) {
                boolean statementRequired;
                boolean timeoutRequired;
                boolean validationRequired;
                boolean recoveryRequired;
                boolean securityRequired;
                boolean poolRequired;
                ModelNode dataSourceNode = property.getValue();
                writer.writeStartElement(isXADataSource ? DataSources.Tag.XA_DATASOURCE.getLocalName() : DataSources.Tag.DATASOURCE.getLocalName());
                Constants.JTA.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.JNDI_NAME.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                writer.writeAttribute("pool-name", property.getName());
                Constants.ENABLED.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.USE_JAVA_CONTEXT.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.SPY.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.USE_CCM.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.CONNECTABLE.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.TRACKING.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.STATISTICS_ENABLED.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                if (!isXADataSource) {
                    Constants.CONNECTION_URL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.DRIVER_CLASS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.DATASOURCE_CLASS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.hasDefined(Constants.CONNECTION_PROPERTIES.getName())) {
                        for (Property connectionProperty : dataSourceNode.get(Constants.CONNECTION_PROPERTIES.getName()).asPropertyList()) {
                            this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().get("value").asString(), DataSource.Tag.CONNECTION_PROPERTY.getLocalName());
                        }
                    }
                }
                if (isXADataSource) {
                    if (dataSourceNode.hasDefined(Constants.XADATASOURCE_PROPERTIES.getName())) {
                        for (Property prop : dataSourceNode.get(Constants.XADATASOURCE_PROPERTIES.getName()).asPropertyList()) {
                            this.writeProperty(writer, dataSourceNode, prop.getName(), prop.getValue().get("value").asString(), XaDataSource.Tag.XA_DATASOURCE_PROPERTY.getLocalName());
                        }
                    }
                    Constants.XA_DATASOURCE_CLASS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                }
                Constants.DATASOURCE_DRIVER.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                if (isXADataSource) {
                    Constants.URL_DELIMITER.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.URL_PROPERTY.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                }
                Constants.NEW_CONNECTION_SQL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                Constants.TRANSACTION_ISOLATION.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                if (!isXADataSource) {
                    Constants.URL_DELIMITER.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                }
                boolean bl = poolRequired = org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.isMarshallable(dataSourceNode) || Constants.ALLOW_MULTIPLE_USERS.isMarshallable(dataSourceNode) || Constants.CONNECTION_LISTENER_CLASS.isMarshallable(dataSourceNode) || Constants.CONNECTION_LISTENER_PROPERTIES.isMarshallable(dataSourceNode);
                if (isXADataSource) {
                    poolRequired = poolRequired || Constants.SAME_RM_OVERRIDE.isMarshallable(dataSourceNode) || Constants.INTERLEAVING.isMarshallable(dataSourceNode) || Constants.NO_TX_SEPARATE_POOL.isMarshallable(dataSourceNode) || Constants.PAD_XID.isMarshallable(dataSourceNode) || Constants.WRAP_XA_RESOURCE.isMarshallable(dataSourceNode);
                }
                boolean capacityRequired = org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.isMarshallable(dataSourceNode);
                boolean bl2 = poolRequired = poolRequired || capacityRequired;
                if (poolRequired) {
                    writer.writeStartElement(isXADataSource ? XaDataSource.Tag.XA_POOL.getLocalName() : DataSource.Tag.POOL.getLocalName());
                    org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.ALLOW_MULTIPLE_USERS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.hasDefined(Constants.CONNECTION_LISTENER_CLASS.getName())) {
                        writer.writeStartElement(DsPool.Tag.CONNECTION_LISTENER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.CONNECTION_LISTENER_CLASS.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.CONNECTION_LISTENER_PROPERTIES.getName())) {
                            for (Property connectionProperty : dataSourceNode.get(Constants.CONNECTION_LISTENER_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    if (capacityRequired) {
                        writer.writeStartElement(DsPool.Tag.CAPACITY.getLocalName());
                        if (dataSourceNode.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.getName())) {
                            writer.writeStartElement(Capacity.Tag.INCREMENTER.getLocalName());
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        }
                        if (dataSourceNode.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.getName())) {
                            writer.writeStartElement(Capacity.Tag.DECREMENTER.getLocalName());
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (isXADataSource) {
                        Constants.SAME_RM_OVERRIDE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.INTERLEAVING.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.NO_TX_SEPARATE_POOL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.PAD_XID.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.WRAP_XA_RESOURCE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    }
                    writer.writeEndElement();
                }
                boolean bl3 = securityRequired = Constants.USERNAME.isMarshallable(dataSourceNode) || Constants.PASSWORD.isMarshallable(dataSourceNode) || Constants.SECURITY_DOMAIN.isMarshallable(dataSourceNode) || Constants.REAUTH_PLUGIN_CLASSNAME.isMarshallable(dataSourceNode) || Constants.REAUTHPLUGIN_PROPERTIES.isMarshallable(dataSourceNode);
                if (securityRequired) {
                    writer.writeStartElement(DataSource.Tag.SECURITY.getLocalName());
                    Constants.USERNAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.PASSWORD.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.SECURITY_DOMAIN.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.hasDefined(Constants.REAUTH_PLUGIN_CLASSNAME.getName())) {
                        writer.writeStartElement(DsSecurity.Tag.REAUTH_PLUGIN.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.REAUTH_PLUGIN_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.REAUTHPLUGIN_PROPERTIES.getName())) {
                            Property connectionProperty;
                            connectionProperty = dataSourceNode.get(Constants.REAUTHPLUGIN_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty.hasNext()) {
                                Property connectionProperty2 = (Property)connectionProperty.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty2.getName(), connectionProperty2.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                boolean bl4 = recoveryRequired = Constants.RECOVERY_USERNAME.isMarshallable(dataSourceNode) || Constants.RECOVERY_PASSWORD.isMarshallable(dataSourceNode) || Constants.RECOVERY_SECURITY_DOMAIN.isMarshallable(dataSourceNode) || Constants.RECOVER_PLUGIN_CLASSNAME.isMarshallable(dataSourceNode) || Constants.NO_RECOVERY.isMarshallable(dataSourceNode) || Constants.RECOVER_PLUGIN_PROPERTIES.isMarshallable(dataSourceNode);
                if (recoveryRequired && isXADataSource) {
                    writer.writeStartElement(XaDataSource.Tag.RECOVERY.getLocalName());
                    Constants.NO_RECOVERY.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                    if (this.hasAnyOf(dataSourceNode, Constants.RECOVERY_USERNAME, Constants.RECOVERY_PASSWORD, Constants.RECOVERY_SECURITY_DOMAIN)) {
                        writer.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                        Constants.RECOVERY_USERNAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.RECOVERY_PASSWORD.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.RECOVERY_SECURITY_DOMAIN.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    if (this.hasAnyOf(dataSourceNode, Constants.RECOVER_PLUGIN_CLASSNAME)) {
                        writer.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.RECOVER_PLUGIN_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.RECOVER_PLUGIN_PROPERTIES.getName())) {
                            for (Object connectionProperty3 : dataSourceNode.get(Constants.RECOVER_PLUGIN_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty3.getName(), connectionProperty3.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                boolean bl5 = validationRequired = Constants.VALID_CONNECTION_CHECKER_CLASSNAME.isMarshallable(dataSourceNode) || Constants.VALID_CONNECTION_CHECKER_PROPERTIES.isMarshallable(dataSourceNode) || Constants.CHECK_VALID_CONNECTION_SQL.isMarshallable(dataSourceNode) || Constants.VALIDATE_ON_MATCH.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.isMarshallable(dataSourceNode) || Constants.STALE_CONNECTION_CHECKER_CLASSNAME.isMarshallable(dataSourceNode) || Constants.STALE_CONNECTION_CHECKER_PROPERTIES.isMarshallable(dataSourceNode) || Constants.EXCEPTION_SORTER_CLASSNAME.isMarshallable(dataSourceNode) || Constants.EXCEPTION_SORTER_PROPERTIES.isMarshallable(dataSourceNode);
                if (validationRequired) {
                    Property connectionProperty;
                    Object connectionProperty3;
                    writer.writeStartElement(DataSource.Tag.VALIDATION.getLocalName());
                    if (dataSourceNode.hasDefined(Constants.VALID_CONNECTION_CHECKER_CLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.VALID_CONNECTION_CHECKER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.VALID_CONNECTION_CHECKER_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.VALID_CONNECTION_CHECKER_PROPERTIES.getName())) {
                            connectionProperty3 = dataSourceNode.get(Constants.VALID_CONNECTION_CHECKER_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty3.hasNext()) {
                                connectionProperty = (Property)connectionProperty3.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    Constants.CHECK_VALID_CONNECTION_SQL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.VALIDATE_ON_MATCH.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.hasDefined(Constants.STALE_CONNECTION_CHECKER_CLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.STALE_CONNECTION_CHECKER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.STALE_CONNECTION_CHECKER_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.STALE_CONNECTION_CHECKER_PROPERTIES.getName())) {
                            connectionProperty3 = dataSourceNode.get(Constants.STALE_CONNECTION_CHECKER_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty3.hasNext()) {
                                connectionProperty = (Property)connectionProperty3.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    if (dataSourceNode.hasDefined(Constants.EXCEPTION_SORTER_CLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.EXCEPTION_SORTER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.EXCEPTION_SORTER_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.EXCEPTION_SORTER_PROPERTIES.getName())) {
                            connectionProperty3 = dataSourceNode.get(Constants.EXCEPTION_SORTER_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty3.hasNext()) {
                                connectionProperty = (Property)connectionProperty3.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                boolean bl6 = timeoutRequired = org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.isMarshallable(dataSourceNode) || Constants.SET_TX_QUERY_TIMEOUT.isMarshallable(dataSourceNode) || Constants.QUERY_TIMEOUT.isMarshallable(dataSourceNode) || Constants.USE_TRY_LOCK.isMarshallable(dataSourceNode) || Constants.ALLOCATION_RETRY.isMarshallable(dataSourceNode) || Constants.ALLOCATION_RETRY_WAIT_MILLIS.isMarshallable(dataSourceNode) || Constants.XA_RESOURCE_TIMEOUT.isMarshallable(dataSourceNode);
                if (timeoutRequired) {
                    writer.writeStartElement(DataSource.Tag.TIMEOUT.getLocalName());
                    Constants.SET_TX_QUERY_TIMEOUT.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.QUERY_TIMEOUT.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.USE_TRY_LOCK.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.ALLOCATION_RETRY.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.ALLOCATION_RETRY_WAIT_MILLIS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.XA_RESOURCE_TIMEOUT.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (statementRequired = this.hasAnyOf(dataSourceNode, Constants.TRACK_STATEMENTS, Constants.PREPARED_STATEMENTS_CACHE_SIZE, Constants.SHARE_PREPARED_STATEMENTS)) {
                    writer.writeStartElement(DataSource.Tag.STATEMENT.getLocalName());
                    Constants.TRACK_STATEMENTS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.PREPARED_STATEMENTS_CACHE_SIZE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.SHARE_PREPARED_STATEMENTS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Driver.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value, String localName) throws XMLStreamException {
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                String content = node.get(identifier).asString();
                if (content.indexOf(10) > -1) {
                    writer.writeCharacters(content);
                } else {
                    char[] chars = content.toCharArray();
                    writer.writeCharacters(chars, 0, chars.length);
                }
                writer.writeEndElement();
            }
        }

        private boolean hasAnyOf(ModelNode node, SimpleAttributeDefinition ... names) {
            for (SimpleAttributeDefinition current : names) {
                if (!this.has(node, current.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", DataSourcesExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            try {
                String localName = null;
                localName = reader.getLocalName();
                Element element = Element.forName(reader.getLocalName());
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.tracef("%s -> %s", localName, (Object)element);
                switch (element) {
                    case SUBSYSTEM: {
                        DsParser parser = new DsParser();
                        parser.parse(reader, list, address);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

