/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.allowedmethods;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.allowedmethods.DeniedMethodKey;
import org.jboss.as.ejb3.component.allowedmethods.MethodType;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.InterceptorContext;

public class AllowedMethodsInformation {
    public static final AllowedMethodsInformation INSTANCE_BMT = new AllowedMethodsInformation(true);
    public static final AllowedMethodsInformation INSTANCE_CMT = new AllowedMethodsInformation(false);
    private final Set<DeniedMethodKey> denied;
    private final Set<DeniedSyncMethodKey> deniedSyncMethods;
    private final boolean beanManagedTransaction;

    protected AllowedMethodsInformation(boolean beanManagedTransaction) {
        this.beanManagedTransaction = beanManagedTransaction;
        HashSet<DeniedMethodKey> denied = new HashSet<DeniedMethodKey>();
        AllowedMethodsInformation.add(denied, InvocationType.SET_ENTITY_CONTEXT, MethodType.TIMER_SERVICE_METHOD);
        AllowedMethodsInformation.add(denied, InvocationType.SET_ENTITY_CONTEXT, MethodType.TIMER_SERVICE_METHOD);
        AllowedMethodsInformation.add(denied, InvocationType.SET_ENTITY_CONTEXT, MethodType.GET_PRIMARY_KEY);
        AllowedMethodsInformation.add(denied, InvocationType.SET_ENTITY_CONTEXT, MethodType.GET_TIMER_SERVICE);
        AllowedMethodsInformation.add(denied, InvocationType.SET_ENTITY_CONTEXT, MethodType.IS_CALLER_IN_ROLE);
        AllowedMethodsInformation.add(denied, InvocationType.SET_ENTITY_CONTEXT, MethodType.GET_CALLER_PRINCIPLE);
        AllowedMethodsInformation.add(denied, InvocationType.HOME_METHOD, MethodType.TIMER_SERVICE_METHOD);
        AllowedMethodsInformation.add(denied, InvocationType.HOME_METHOD, MethodType.GET_PRIMARY_KEY);
        AllowedMethodsInformation.add(denied, InvocationType.ENTITY_EJB_CREATE, MethodType.TIMER_SERVICE_METHOD);
        AllowedMethodsInformation.add(denied, InvocationType.ENTITY_EJB_CREATE, MethodType.GET_PRIMARY_KEY);
        this.setup(denied);
        this.denied = Collections.unmodifiableSet(denied);
        HashSet<DeniedSyncMethodKey> deniedSync = new HashSet<DeniedSyncMethodKey>();
        AllowedMethodsInformation.add(deniedSync, CurrentSynchronizationCallback.CallbackType.AFTER_COMPLETION, MethodType.TIMER_SERVICE_METHOD);
        AllowedMethodsInformation.add(deniedSync, CurrentSynchronizationCallback.CallbackType.AFTER_COMPLETION, MethodType.GET_ROLLBACK_ONLY);
        AllowedMethodsInformation.add(deniedSync, CurrentSynchronizationCallback.CallbackType.AFTER_COMPLETION, MethodType.SET_ROLLBACK_ONLY);
        this.deniedSyncMethods = Collections.unmodifiableSet(deniedSync);
    }

    protected void setup(Set<DeniedMethodKey> denied) {
    }

    protected static void add(Set<DeniedMethodKey> otherDenied, InvocationType setEntityContext, MethodType timerServiceMethod) {
        otherDenied.add(new DeniedMethodKey(setEntityContext, timerServiceMethod));
    }

    protected static void add(Set<DeniedSyncMethodKey> otherDenied, CurrentSynchronizationCallback.CallbackType callbackType, MethodType timerServiceMethod) {
        otherDenied.add(new DeniedSyncMethodKey(callbackType, timerServiceMethod));
    }

    public static void checkAllowed(MethodType methodType) {
        InterceptorContext context = CurrentInvocationContext.get();
        if (context == null) {
            return;
        }
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof EJBComponent)) {
            return;
        }
        InvocationType invocationType = (InvocationType)context.getPrivateData(InvocationType.class);
        ((EJBComponent)component).getAllowedMethodsInformation().realCheckPermission(methodType, invocationType);
    }

    private void checkTransactionSync(MethodType methodType) {
        CurrentSynchronizationCallback.CallbackType currentSync = CurrentSynchronizationCallback.get();
        if (currentSync != null && this.deniedSyncMethods.contains(new DeniedSyncMethodKey(currentSync, methodType))) {
            this.throwException(methodType, currentSync);
        }
    }

    protected void realCheckPermission(MethodType methodType, InvocationType invocationType) {
        this.checkTransactionSync(methodType);
        if (invocationType != null && this.denied.contains(new DeniedMethodKey(invocationType, methodType))) {
            this.throwException(methodType, invocationType);
        }
        if (invocationType != InvocationType.CONCURRENT_CONTEXT && !this.beanManagedTransaction && methodType == MethodType.GET_USER_TRANSACTION) {
            throw EjbLogger.ROOT_LOGGER.unauthorizedAccessToUserTransaction();
        }
    }

    protected void throwException(MethodType methodType, InvocationType invocationType) {
        throw EjbLogger.ROOT_LOGGER.cannotCallMethod(methodType.getLabel(), invocationType.getLabel());
    }

    protected void throwException(MethodType methodType, CurrentSynchronizationCallback.CallbackType callback) {
        throw EjbLogger.ROOT_LOGGER.cannotCallMethod(methodType.getLabel(), callback.name());
    }

    private static class DeniedSyncMethodKey {
        private final CurrentSynchronizationCallback.CallbackType callbackType;
        private final MethodType methodType;

        public DeniedSyncMethodKey(CurrentSynchronizationCallback.CallbackType callbackType, MethodType methodType) {
            this.callbackType = callbackType;
            this.methodType = methodType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeniedSyncMethodKey that = (DeniedSyncMethodKey)o;
            if (this.callbackType != that.callbackType) {
                return false;
            }
            return this.methodType == that.methodType;
        }

        public int hashCode() {
            int result = this.callbackType != null ? this.callbackType.hashCode() : 0;
            result = 31 * result + (this.methodType != null ? this.methodType.hashCode() : 0);
            return result;
        }
    }
}

