/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.RemoteViewInjectionSource;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.ControlPointService;
import org.wildfly.extension.requestcontroller.RequestControllerActivationMarker;
import org.wildfly.extension.requestcontroller.RunResult;

public class EjbJndiBindingsDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private final boolean appclient;

    public EjbJndiBindingsDeploymentUnitProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions != null) {
            for (ComponentDescription componentDescription : componentDescriptions) {
                if (!(componentDescription instanceof SessionBeanComponentDescription) && !(componentDescription instanceof EntityBeanComponentDescription)) continue;
                this.setupJNDIBindings((EJBComponentDescription)componentDescription, deploymentUnit);
            }
        }
        if (this.appclient) {
            for (ComponentDescription component : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS)) {
                this.setupJNDIBindings((EJBComponentDescription)component, deploymentUnit);
            }
        }
    }

    private void setupJNDIBindings(EJBComponentDescription sessionBean, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        Set views = sessionBean.getViews();
        if (views == null || views.isEmpty()) {
            EjbLogger.DEPLOYMENT_LOGGER.noJNDIBindingsForSessionBean(sessionBean.getEJBName());
            return;
        }
        String applicationName = sessionBean.getModuleDescription().getEarApplicationName();
        String globalJNDIBaseName = "java:global/" + (applicationName != null ? applicationName + "/" : "") + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String appJNDIBaseName = "java:app/" + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String moduleJNDIBaseName = "java:module/" + sessionBean.getEJBName();
        String remoteExportedJNDIBaseName = "java:jboss/exported/" + (applicationName != null ? applicationName + "/" : "") + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        StringBuilder jndiBindingsLogMessage = new StringBuilder();
        jndiBindingsLogMessage.append(System.lineSeparator()).append(System.lineSeparator());
        EJBViewDescription ejbViewDescription = null;
        for (ViewDescription viewDescription : views) {
            ejbViewDescription = (EJBViewDescription)viewDescription;
            if (this.appclient && ejbViewDescription.getMethodIntf() != MethodIntf.REMOTE && ejbViewDescription.getMethodIntf() != MethodIntf.HOME || !ejbViewDescription.hasJNDIBindings()) continue;
            String viewClassName = ejbViewDescription.getViewClassName();
            String globalJNDIName = globalJNDIBaseName + "!" + viewClassName;
            this.registerBinding(sessionBean, viewDescription, globalJNDIName);
            this.logBinding(jndiBindingsLogMessage, globalJNDIName);
            String appJNDIName = appJNDIBaseName + "!" + viewClassName;
            this.registerBinding(sessionBean, viewDescription, appJNDIName);
            this.logBinding(jndiBindingsLogMessage, appJNDIName);
            String moduleJNDIName = moduleJNDIBaseName + "!" + viewClassName;
            this.registerBinding(sessionBean, viewDescription, moduleJNDIName);
            this.logBinding(jndiBindingsLogMessage, moduleJNDIName);
            if (ejbViewDescription.getMethodIntf() != MethodIntf.REMOTE && ejbViewDescription.getMethodIntf() != MethodIntf.HOME) continue;
            String remoteJNDIName = remoteExportedJNDIBaseName + "!" + viewClassName;
            if (RequestControllerActivationMarker.isRequestControllerEnabled((DeploymentUnit)deploymentUnit)) {
                this.registerControlPointBinding(sessionBean, viewDescription, remoteJNDIName, deploymentUnit);
            } else {
                this.registerBinding(sessionBean, viewDescription, remoteJNDIName);
            }
            this.logBinding(jndiBindingsLogMessage, remoteJNDIName);
        }
        if (views.size() == 1) {
            EJBViewDescription viewDescription = (EJBViewDescription)((Object)views.iterator().next());
            if (ejbViewDescription.hasJNDIBindings()) {
                this.registerBinding(sessionBean, viewDescription, globalJNDIBaseName);
                this.logBinding(jndiBindingsLogMessage, globalJNDIBaseName);
                this.registerBinding(sessionBean, viewDescription, appJNDIBaseName);
                this.logBinding(jndiBindingsLogMessage, appJNDIBaseName);
                this.registerBinding(sessionBean, viewDescription, moduleJNDIBaseName);
                this.logBinding(jndiBindingsLogMessage, moduleJNDIBaseName);
            }
        }
        EjbLogger.DEPLOYMENT_LOGGER.jndiBindings(sessionBean.getEJBName(), deploymentUnit, jndiBindingsLogMessage);
    }

    private void registerBinding(EJBComponentDescription componentDescription, ViewDescription viewDescription, String jndiName) {
        if (this.appclient) {
            this.registerRemoteBinding(componentDescription, viewDescription, jndiName);
        } else {
            viewDescription.getBindingNames().add(jndiName);
        }
    }

    private void registerRemoteBinding(EJBComponentDescription componentDescription, ViewDescription viewDescription, String jndiName) {
        EEModuleDescription moduleDescription = componentDescription.getModuleDescription();
        final InjectedValue viewClassLoader = new InjectedValue();
        moduleDescription.getBindingConfigurations().add(new BindingConfiguration(jndiName, (InjectionSource)new RemoteViewInjectionSource(null, moduleDescription.getEarApplicationName(), moduleDescription.getModuleName(), moduleDescription.getDistinctName(), componentDescription.getComponentName(), viewDescription.getViewClassName(), componentDescription.isStateful(), (Value<ClassLoader>)viewClassLoader)));
        componentDescription.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                viewClassLoader.setValue(Values.immediateValue((Object)configuration.getModuleClassLoader()));
            }
        });
    }

    private void registerControlPointBinding(final EJBComponentDescription componentDescription, ViewDescription viewDescription, String jndiName, final DeploymentUnit deploymentUnit) {
        EEModuleDescription moduleDescription = componentDescription.getModuleDescription();
        final InjectedValue viewClassLoader = new InjectedValue();
        final InjectedValue controlPointInjectedValue = new InjectedValue();
        final RemoteViewInjectionSource delegate = new RemoteViewInjectionSource(null, moduleDescription.getEarApplicationName(), moduleDescription.getModuleName(), moduleDescription.getDistinctName(), componentDescription.getComponentName(), viewDescription.getViewClassName(), componentDescription.isStateful(), (Value<ClassLoader>)viewClassLoader);
        componentDescription.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                viewClassLoader.setValue(Values.immediateValue((Object)configuration.getModuleClassLoader()));
                configuration.getCreateDependencies().add(new DependencyConfigurator<Service<Component>>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, Service<Component> service) throws DeploymentUnitProcessingException {
                        serviceBuilder.addDependency(ControlPointService.serviceName((String)(deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName()), (String)("ejb." + deploymentUnit.getName() + "." + componentDescription.getComponentName())), ControlPoint.class, (Injector)controlPointInjectedValue);
                    }
                });
            }
        });
        InjectionSource is = new InjectionSource(){

            public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
                final InjectedValue delegateInjection = new InjectedValue();
                delegate.getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)delegateInjection);
                injector.inject((Object)new ManagedReferenceFactory(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ManagedReference getReference() {
                        ManagedReference managedReference;
                        ControlPoint cp = (ControlPoint)controlPointInjectedValue.getValue();
                        RunResult res = cp.beginRequest();
                        if (res != RunResult.RUN) {
                            throw EjbLogger.ROOT_LOGGER.containerSuspended();
                        }
                        try {
                            managedReference = ((ManagedReferenceFactory)delegateInjection.getValue()).getReference();
                        }
                        catch (Throwable throwable) {
                            try {
                                cp.requestComplete();
                                throw throwable;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        cp.requestComplete();
                        return managedReference;
                    }
                });
            }
        };
        moduleDescription.getBindingConfigurations().add(new BindingConfiguration(jndiName, is));
    }

    private void logBinding(StringBuilder jndiBindingsLogMessage, String jndiName) {
        jndiBindingsLogMessage.append("\t");
        jndiBindingsLogMessage.append(jndiName);
        jndiBindingsLogMessage.append(System.lineSeparator());
    }

    public void undeploy(DeploymentUnit context) {
    }
}

