/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.GenericModelDescribeOperationHandler;
import org.jboss.dmr.ModelNode;

public class ProfileDescribeHandler
extends GenericModelDescribeOperationHandler {
    public static final ProfileDescribeHandler INSTANCE = new ProfileDescribeHandler();
    private static final Set<Action.ActionEffect> DESCRIBE_EFFECTS = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_CONFIG));

    private ProfileDescribeHandler() {
        super("describe", true);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AuthorizationResult authResult = context.authorize(operation, DESCRIBE_EFFECTS);
        if (authResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
            String operationName = operation.get("operation").asString();
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            throw ControllerLogger.ACCESS_LOGGER.unauthorized(operationName, address, authResult.getExplanation());
        }
        super.execute(context, operation);
    }

    @Override
    protected void processMore(OperationContext context, ModelNode operation, Resource resource, PathAddress address, Map<String, ModelNode> includeResults) throws OperationFailedException {
        ModelNode profile = resource.getModel();
        if (profile.hasDefined("includes")) {
            for (ModelNode include : profile.get("includes").asList()) {
                String includeName = include.asString();
                ModelNode includeRsp = new ModelNode();
                includeResults.put(includeName, includeRsp);
                ModelNode includeAddress = address.subAddress(0, address.size() - 1).append(new PathElement[]{PathElement.pathElement((String)"profile", (String)includeName)}).toModelNode();
                ModelNode newOp = operation.clone();
                newOp.get("address").set(includeAddress);
                context.addStep(includeRsp, newOp, (OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL, true);
            }
        }
    }
}

