/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import org.jboss.wsf.spi.deployment.Reference;

public final class ReferenceFactory {
    private ReferenceFactory() {
    }

    public static Reference newInitializedReference(Reference reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return ReferenceFactory.newInitializedReference(reference.getValue());
    }

    public static Reference newInitializedReference(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return ReferenceFactory.newReference(reference, true);
    }

    public static Reference newUninitializedReference(Reference reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return ReferenceFactory.newUninitializedReference(reference.getValue());
    }

    public static Reference newUninitializedReference(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return ReferenceFactory.newReference(reference, false);
    }

    private static Reference newReference(Object reference, boolean initialized) {
        return new ReferenceImpl(reference, initialized);
    }

    private static final class ReferenceImpl
    implements Reference {
        private final Object reference;
        private volatile boolean initialized;

        private ReferenceImpl(Object reference, boolean initialized) {
            this.reference = reference;
            this.initialized = initialized;
        }

        public Object getValue() {
            return this.reference;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized() {
            this.initialized = true;
        }
    }
}

