/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.MutableCacheEntry;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.marshalling.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionCacheEntry;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionEntry;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesCacheKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class CoarseSessionFactory<L>
implements SessionFactory<CoarseSessionEntry<L>, L> {
    private final SessionContext context;
    private final Cache<String, CoarseSessionCacheEntry<L>> sessionCache;
    private final Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>> attributesCache;
    private final Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSessionFactory(Cache<String, CoarseSessionCacheEntry<L>> sessionCache, Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>> attributesCache, SessionContext context, Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> marshaller, LocalContextFactory<L> localContextFactory) {
        this.sessionCache = sessionCache;
        this.attributesCache = attributesCache;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public Session<L> createSession(String id, CoarseSessionEntry<L> entry) {
        MutableCacheEntry<CoarseSessionCacheEntry<L>> sessionEntry = entry.getMutableSessionEntry();
        MutableCacheEntry<Map<String, Object>> attributesEntry = entry.getMutableAttributesEntry();
        SessionMetaData metaData = ((CoarseSessionCacheEntry)sessionEntry.getValue()).getMetaData();
        CoarseSessionAttributes attributes = new CoarseSessionAttributes((Map)attributesEntry.getValue(), attributesEntry.getMutator());
        return new InfinispanSession(id, metaData, attributes, ((CoarseSessionCacheEntry)sessionEntry.getValue()).getLocalContext(), this.localContextFactory, this.context, sessionEntry.getMutator(), this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, CoarseSessionEntry<L> entry) {
        MutableCacheEntry<CoarseSessionCacheEntry<L>> sessionEntry = entry.getMutableSessionEntry();
        MutableCacheEntry<Map<String, Object>> attributesEntry = entry.getMutableAttributesEntry();
        SessionMetaData metaData = ((CoarseSessionCacheEntry)sessionEntry.getValue()).getMetaData();
        CoarseImmutableSessionAttributes attributes = new CoarseImmutableSessionAttributes((Map)attributesEntry.getValue());
        return new InfinispanImmutableSession(id, (ImmutableSessionMetaData)metaData, attributes, this.context);
    }

    public CoarseSessionEntry<L> createValue(String id, Void context) {
        CoarseSessionCacheEntry entry = new CoarseSessionCacheEntry(new SimpleSessionMetaData());
        CoarseSessionCacheEntry existingEntry = (CoarseSessionCacheEntry)this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)id, entry);
        SessionAttributesCacheKey key = new SessionAttributesCacheKey(id);
        HashMap attributes = new HashMap();
        MutableCacheEntry attributesEntry = new MutableCacheEntry(attributes, Mutator.PASSIVE);
        MarshalledValue value = (MarshalledValue)this.marshaller.write(attributes);
        if (existingEntry == null) {
            this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)key, (Object)value);
            MutableCacheEntry sessionEntry = new MutableCacheEntry(entry, Mutator.PASSIVE);
            return new CoarseSessionEntry(sessionEntry, (MutableCacheEntry<Map<String, Object>>)attributesEntry);
        }
        MutableCacheEntry sessionEntry = new MutableCacheEntry((Object)existingEntry, (Mutator)new CacheEntryMutator(this.sessionCache, (Object)id, (Object)existingEntry));
        MarshalledValue existingValue = (MarshalledValue)this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)key, (Object)value);
        if (existingValue != null) {
            try {
                Map existingAttributes = (Map)this.marshaller.read((Object)existingValue);
                MutableCacheEntry existingAttributesEntry = new MutableCacheEntry((Object)existingAttributes, (Mutator)new CacheEntryMutator(this.attributesCache, (Object)key, (Object)existingValue));
                return new CoarseSessionEntry(sessionEntry, (MutableCacheEntry<Map<String, Object>>)existingAttributesEntry);
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                new CacheEntryMutator(this.attributesCache, (Object)key, (Object)value).mutate();
            }
        }
        return new CoarseSessionEntry(sessionEntry, (MutableCacheEntry<Map<String, Object>>)attributesEntry);
    }

    public CoarseSessionEntry<L> findValue(String id) {
        CoarseSessionCacheEntry entry = (CoarseSessionCacheEntry)this.sessionCache.get((Object)id);
        if (entry != null) {
            MutableCacheEntry sessionEntry = new MutableCacheEntry((Object)entry, (Mutator)new CacheEntryMutator(this.sessionCache, (Object)id, (Object)entry));
            SessionAttributesCacheKey key = new SessionAttributesCacheKey(id);
            MarshalledValue value = (MarshalledValue)this.attributesCache.get((Object)key);
            if (value != null) {
                try {
                    Map attributes = (Map)this.marshaller.read((Object)value);
                    return new CoarseSessionEntry(sessionEntry, (MutableCacheEntry<Map<String, Object>>)new MutableCacheEntry((Object)attributes, (Mutator)new CacheEntryMutator(this.attributesCache, (Object)key, (Object)value)));
                }
                catch (InvalidSerializedFormException e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                }
            }
            this.remove(id);
        }
        return null;
    }

    public void remove(String id) {
        this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)id);
        this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributesCacheKey(id));
    }

    public void evict(String id) {
        try {
            this.sessionCache.evict((Object)id);
            this.attributesCache.evict((Object)new SessionAttributesCacheKey(id));
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
        }
    }
}

