/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.X509Token;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509TokenPolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(X509TokenPolicyValidator.class);
    private static final String X509_V3_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String PKI_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";

    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "X509Token");
        if (!ais.isEmpty()) {
            this.parsePolicies(ais, message, signedResults, results);
            this.assertPolicy(aim, "WssX509PkiPathV1Token10");
            this.assertPolicy(aim, "WssX509PkiPathV1Token11");
            this.assertPolicy(aim, "WssX509V1Token10");
            this.assertPolicy(aim, "WssX509V1Token11");
            this.assertPolicy(aim, "WssX509V3Token10");
            this.assertPolicy(aim, "WssX509V3Token11");
            this.assertPolicy(aim, "RequireIssuerSerialReference");
            this.assertPolicy(aim, "RequireThumbprintReference");
            this.assertPolicy(aim, "RequireKeyIdentifierReference");
            this.assertPolicy(aim, "RequireEmbeddedTokenReference");
        }
        return true;
    }

    private void parsePolicies(Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> results) {
        List bstResults = WSSecurityUtil.fetchAllActionResults(results, (int)4096);
        for (AssertionInfo ai : ais) {
            X509Token x509TokenPolicy = (X509Token)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired((AbstractToken)x509TokenPolicy, message)) continue;
            if (bstResults.isEmpty() && signedResults.isEmpty()) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                continue;
            }
            if (this.checkTokenType(x509TokenPolicy.getTokenType(), bstResults, signedResults)) continue;
            ai.setNotAsserted("An incorrect X.509 Token Type is detected");
        }
    }

    private boolean checkTokenType(X509Token.TokenType tokenType, List<WSSecurityEngineResult> bstResults, List<WSSecurityEngineResult> signedResults) {
        if (bstResults.isEmpty() && signedResults.isEmpty()) {
            return false;
        }
        String requiredType = X509_V3_VALUETYPE;
        boolean v3certRequired = false;
        if (tokenType == X509Token.TokenType.WssX509PkiPathV1Token10 || tokenType == X509Token.TokenType.WssX509PkiPathV1Token11) {
            requiredType = PKI_VALUETYPE;
        } else if (tokenType == X509Token.TokenType.WssX509V3Token10 || tokenType == X509Token.TokenType.WssX509V3Token11) {
            v3certRequired = true;
        }
        for (WSSecurityEngineResult result : bstResults) {
            String type;
            BinarySecurity binarySecurityToken = (BinarySecurity)result.get((Object)"binary-security-token");
            if (binarySecurityToken == null || !requiredType.equals(type = binarySecurityToken.getValueType())) continue;
            if (v3certRequired && binarySecurityToken instanceof X509Security) {
                try {
                    X509Certificate cert = ((X509Security)binarySecurityToken).getX509Certificate(null);
                    if (cert == null || cert.getVersion() != 3) continue;
                    return true;
                }
                catch (WSSecurityException e) {
                    LOG.log(Level.FINE, e.getMessage());
                    continue;
                }
            }
            return true;
        }
        if (X509_V3_VALUETYPE.equals(requiredType)) {
            for (WSSecurityEngineResult result : signedResults) {
                Element signatureElement;
                Element keyIdentifier;
                STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)result.get((Object)"x509-reference-type");
                if (STRParser.REFERENCE_TYPE.KEY_IDENTIFIER != referenceType || (keyIdentifier = this.getKeyIdentifier(signatureElement = (Element)result.get((Object)"token-element"))) == null || !X509_V3_VALUETYPE.equals(keyIdentifier.getAttributeNS(null, "ValueType"))) continue;
                try {
                    X509Security token = new X509Security(keyIdentifier, new BSPEnforcer(true));
                    X509Certificate cert = token.getX509Certificate(null);
                    if (cert == null || cert.getVersion() != 3) continue;
                    return true;
                }
                catch (WSSecurityException e) {
                    LOG.log(Level.FINE, e.getMessage());
                }
            }
        }
        return false;
    }

    private Element getKeyIdentifier(Element signatureElement) {
        Element strElement;
        Element keyInfoElement;
        if (signatureElement != null && (keyInfoElement = WSSecurityUtil.getDirectChildElement((Node)signatureElement, (String)"KeyInfo", (String)"http://www.w3.org/2000/09/xmldsig#")) != null && (strElement = WSSecurityUtil.getDirectChildElement((Node)keyInfoElement, (String)"SecurityTokenReference", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) != null) {
            Element kiElement = WSSecurityUtil.getDirectChildElement((Node)strElement, (String)"KeyIdentifier", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            return kiElement;
        }
        return null;
    }
}

