/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

class AddressSettingsValidator {
    static OperationStepHandler ADD_VALIDATOR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String addressSetting = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            Resource activeMQServer = context.readResourceFromRoot(MessagingServices.getActiveMQServerPathAddress(address), true);
            AddressSettingsValidator.checkExpiryAddress(context, operation, activeMQServer, addressSetting);
            AddressSettingsValidator.checkDeadLetterAddress(context, operation, activeMQServer, addressSetting);
        }
    };

    AddressSettingsValidator() {
    }

    static void validateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String addressSetting = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        Resource activeMQServer = context.readResourceFromRoot(MessagingServices.getActiveMQServerPathAddress(address), true);
        AddressSettingsValidator.checkExpiryAddress(context, resource.getModel(), activeMQServer, addressSetting);
        AddressSettingsValidator.checkDeadLetterAddress(context, resource.getModel(), activeMQServer, addressSetting);
    }

    private static void checkExpiryAddress(OperationContext context, ModelNode model, Resource activeMQServer, String addressSetting) throws OperationFailedException {
        ModelNode expiryAddress = CommonAttributes.EXPIRY_ADDRESS.resolveModelAttribute(context, model);
        if (!AddressSettingsValidator.findMatchingResource(expiryAddress, activeMQServer)) {
            MessagingLogger.ROOT_LOGGER.noMatchingExpiryAddress(expiryAddress.asString(), addressSetting);
        }
    }

    private static void checkDeadLetterAddress(OperationContext context, ModelNode model, Resource activeMQServer, String addressSetting) throws OperationFailedException {
        ModelNode deadLetterAddress = CommonAttributes.DEAD_LETTER_ADDRESS.resolveModelAttribute(context, model);
        if (!AddressSettingsValidator.findMatchingResource(deadLetterAddress, activeMQServer)) {
            MessagingLogger.ROOT_LOGGER.noMatchingDeadLetterAddress(deadLetterAddress.asString(), addressSetting);
        }
    }

    private static boolean findMatchingResource(ModelNode addressNode, Resource activeMQServer) {
        String addressPrefix;
        String childType;
        if (!addressNode.isDefined()) {
            return true;
        }
        String address = addressNode.asString();
        if (address.startsWith("jms.queue.")) {
            childType = "jms-queue";
            addressPrefix = "jms.queue.";
        } else if (address.startsWith("jms.topic.")) {
            childType = "jms-topic";
            addressPrefix = "jms.topic.";
        } else {
            childType = "core-queue";
            addressPrefix = "";
        }
        for (String childName : activeMQServer.getChildrenNames(childType)) {
            if (!address.equals(addressPrefix + childName)) continue;
            return true;
        }
        return false;
    }
}

