/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.levels.internal;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.picketlink.Identity;
import org.picketlink.annotations.PicketLink;
import org.picketlink.authentication.levels.Level;
import org.picketlink.authentication.levels.SecurityLevelResolver;
import org.picketlink.authentication.levels.annotations.SecurityLevel;
import org.picketlink.common.exceptions.PicketLinkException;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.producer.LevelFactoryResolver;

@RequestScoped
@PicketLink
public class CredentialLevelResolver
implements SecurityLevelResolver {
    @Inject
    DefaultLoginCredentials credentials;
    @Inject
    @Any
    private Identity identity;
    @Inject
    private LevelFactoryResolver levelFactoryResolver;

    protected String getCredentialLevel() {
        if (!this.identity.isLoggedIn()) {
            throw new PicketLinkException();
        }
        if (this.credentials == null) {
            throw new PicketLinkException();
        }
        Object cred = this.credentials.getCredential();
        if (cred == null) {
            throw new PicketLinkException();
        }
        return this.getLevelOfClass(cred);
    }

    private String getLevelOfClass(Object obj) {
        SecurityLevel sl = obj.getClass().getAnnotation(SecurityLevel.class);
        if (sl == null) {
            throw new PicketLinkException();
        }
        return sl.value();
    }

    public Level resolve() {
        try {
            String level = this.getCredentialLevel();
            return this.levelFactoryResolver.resolve().createLevel(level);
        }
        catch (PicketLinkException e) {
            return null;
        }
    }
}

