/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.utils.UUID;

public class FileLockNodeManager
extends NodeManager {
    private static final int LIVE_LOCK_POS = 1;
    private static final int BACKUP_LOCK_POS = 2;
    private static final int LOCK_LENGTH = 1;
    private static final byte LIVE = 76;
    private static final byte FAILINGBACK = 70;
    private static final byte PAUSED = 80;
    private static final byte NOT_STARTED = 78;
    private FileLock liveLock;
    private FileLock backupLock;
    protected long lockAcquisitionTimeout = -1L;
    protected boolean interrupted = false;

    public FileLockNodeManager(String directory, boolean replicatedBackup) {
        super(replicatedBackup, directory);
    }

    public FileLockNodeManager(String directory, boolean replicatedBackup, long lockAcquisitionTimeout) {
        super(replicatedBackup, directory);
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        if (!this.replicatedBackup) {
            this.setUpServerLockFile();
        }
        super.start();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.getState() == 70;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        FileLock liveAttemptLock = this.tryLock(1);
        if (liveAttemptLock == null) {
            return true;
        }
        liveAttemptLock.release();
        return false;
    }

    public boolean isLiveLocked() {
        return this.liveLock != null;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public final void releaseBackup() throws Exception {
        if (this.backupLock != null) {
            this.backupLock.release();
            this.backupLock = null;
        }
    }

    @Override
    public void awaitLiveNode() throws Exception {
        byte state;
        while (true) {
            state = this.getState();
            while (state == 78 || state == 48) {
                ActiveMQServerLogger.LOGGER.debug("awaiting live node startup state='" + state + "'");
                Thread.sleep(2000L);
                state = this.getState();
            }
            this.liveLock = this.lock(1);
            if (this.interrupted) {
                this.interrupted = false;
                throw new InterruptedException("Lock was interrupted");
            }
            state = this.getState();
            if (state == 80) {
                this.liveLock.release();
                ActiveMQServerLogger.LOGGER.debug("awaiting live node restarting");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 70) {
                this.liveLock.release();
                ActiveMQServerLogger.LOGGER.debug("awaiting live node failing back");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 76) break;
        }
        ActiveMQServerLogger.LOGGER.debug("acquired live node lock state = " + (char)state);
    }

    @Override
    public void startBackup() throws Exception {
        assert (!this.replicatedBackup);
        ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
        this.backupLock = this.lock(2);
        ActiveMQServerLogger.LOGGER.gotBackupLock();
        if (this.getUUID() == null) {
            this.readNodeId();
        }
    }

    @Override
    public void startLiveNode() throws Exception {
        this.setFailingBack();
        String timeoutMessage = this.lockAcquisitionTimeout == -1L ? "indefinitely" : this.lockAcquisitionTimeout + " milliseconds";
        ActiveMQServerLogger.LOGGER.waitingToObtainLiveLock(timeoutMessage);
        this.liveLock = this.lock(1);
        ActiveMQServerLogger.LOGGER.obtainedLiveLock();
        this.setLive();
    }

    @Override
    public void pauseLiveServer() throws Exception {
        this.setPaused();
        if (this.liveLock != null) {
            this.liveLock.release();
        }
    }

    @Override
    public void crashLiveServer() throws Exception {
        if (this.liveLock != null) {
            this.liveLock.release();
            this.liveLock = null;
        }
    }

    private void setLive() throws Exception {
        this.writeFileLockStatus((byte)76);
    }

    private void setFailingBack() throws Exception {
        this.writeFileLockStatus((byte)70);
    }

    private void setPaused() throws Exception {
        this.writeFileLockStatus((byte)80);
    }

    private void writeFileLockStatus(byte status) throws IOException {
        if (this.replicatedBackup && this.channel == null) {
            return;
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put(status);
        bb.position(0);
        this.channel.write(bb, 0L);
        this.channel.force(true);
    }

    private byte getState() throws Exception {
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        int read = this.channel.read(bb, 0L);
        if (read <= 0) {
            return 78;
        }
        return bb.get(0);
    }

    @Override
    public final SimpleString readNodeId() throws ActiveMQIllegalStateException, IOException {
        ByteBuffer id = ByteBuffer.allocateDirect(16);
        int read = this.channel.read(id, 3L);
        if (read != 16) {
            throw new ActiveMQIllegalStateException("live server did not write id to file");
        }
        byte[] bytes = new byte[16];
        id.position(0);
        id.get(bytes);
        this.setUUID(new UUID(1, bytes));
        return this.getNodeId();
    }

    protected FileLock tryLock(int lockPos) throws Exception {
        try {
            return this.channel.tryLock(lockPos, 1L, false);
        }
        catch (OverlappingFileLockException ex) {
            return null;
        }
    }

    protected FileLock lock(int liveLockPos) throws Exception {
        FileLock lock;
        long start = System.currentTimeMillis();
        while (!this.interrupted) {
            lock = null;
            try {
                lock = this.channel.tryLock(liveLockPos, 1L, false);
            }
            catch (OverlappingFileLockException ex) {
                // empty catch block
            }
            if (lock == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return null;
                }
                if (this.lockAcquisitionTimeout == -1L || System.currentTimeMillis() - start <= this.lockAcquisitionTimeout) continue;
                throw new Exception("timed out waiting for lock");
            }
            return lock;
        }
        do {
            if ((lock = this.channel.tryLock(liveLockPos, 1L, false)) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
            if (!this.interrupted) continue;
            this.interrupted = false;
            throw new IOException("Lock was interrupted");
        } while (lock == null);
        return lock;
    }
}

