/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.idp;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContextAssociation;
import org.picketlink.identity.federation.bindings.wildfly.idp.PicketLinkUndertowPrincipal;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndertowRoleGenerator
implements RoleGenerator {
    public List<String> generateRoles(Principal principal) {
        if (principal instanceof PicketLinkUndertowPrincipal) {
            PicketLinkUndertowPrincipal pup = (PicketLinkUndertowPrincipal)principal;
            return Collections.unmodifiableList(pup.getRoles());
        }
        return this.fromSubject();
    }

    private List<String> fromSubject() {
        Set<Group> groups;
        ArrayList<String> roles = new ArrayList<String>();
        Subject subject = SecurityContextAssociation.getSubject();
        if (subject != null && (groups = subject.getPrincipals(Group.class)) != null) {
            for (Group group : groups) {
                if (!"Roles".equals(group.getName())) continue;
                Enumeration subjectRoles = group.members();
                while (subjectRoles.hasMoreElements()) {
                    Principal role = (Principal)subjectRoles.nextElement();
                    roles.add(role.getName());
                }
            }
        }
        return Collections.unmodifiableList(roles);
    }
}

