/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteConfigurationBuilder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class RelayConfigurationBuilder
extends AbstractProtocolConfigurationBuilder<RelayConfiguration>
implements RelayConfiguration {
    private final List<ValueDependency<RemoteSiteConfiguration>> sites = new LinkedList<ValueDependency<RemoteSiteConfiguration>>();
    private String siteName = null;

    public RelayConfigurationBuilder(String stackName) {
        super(stackName, "relay.RELAY2");
    }

    @Override
    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.stackName).append(new String[]{"relay"});
    }

    @Override
    public ServiceBuilder<RelayConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        for (Dependency dependency : this.sites) {
            dependency.register(builder);
        }
        return builder;
    }

    public RelayConfiguration getValue() {
        return this;
    }

    public RelayConfigurationBuilder setSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    public RemoteSiteConfigurationBuilder addRemoteSite(String name, String channel) {
        RemoteSiteConfigurationBuilder builder = new RemoteSiteConfigurationBuilder(this.stackName, name).setChannel(channel);
        this.sites.add((ValueDependency<RemoteSiteConfiguration>)new InjectedValueDependency((ServiceNameProvider)builder, RemoteSiteConfiguration.class));
        return builder;
    }

    public RelayConfigurationBuilder setModule(ModuleIdentifier module) {
        super.setModule(module);
        return this;
    }

    public RelayConfigurationBuilder setSocketBinding(String socketBindingName) {
        super.setSocketBinding(socketBindingName);
        return this;
    }

    public RelayConfigurationBuilder addProperty(String name, String value) {
        super.addProperty(name, value);
        return this;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public List<RemoteSiteConfiguration> getRemoteSites() {
        ArrayList<RemoteSiteConfiguration> sites = new ArrayList<RemoteSiteConfiguration>(this.sites.size());
        for (ValueDependency<RemoteSiteConfiguration> site : this.sites) {
            sites.add((RemoteSiteConfiguration)site.getValue());
        }
        return sites;
    }
}

