/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.AbstractIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.spi.ContextInitializer;

public class LDAPIdentityStoreConfiguration
extends AbstractIdentityStoreConfiguration {
    private final String ldapURL;
    private String factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
    private String authType = "simple";
    private String protocol;
    private final String bindDN;
    private final String bindCredential;
    private final boolean activeDirectory;
    private final Properties connectionProperties;
    private final boolean pagination;
    private final String uniqueIdentifierAttributeName;
    private String baseDN;
    private final Map<Class<? extends AttributedType>, LDAPMappingConfiguration> mappingConfig;

    LDAPIdentityStoreConfiguration(String url, Properties connectionProperties, String bindDN, String bindCredential, String baseDN, boolean activeDirectory, boolean pagination, String uniqueIdentifierAttributeName, Map<Class<? extends AttributedType>, LDAPMappingConfiguration> mappingConfig, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, Set<Class<? extends CredentialHandler>> credentialHandlers, boolean supportsCredential) {
        super(supportedTypes, unsupportedTypes, contextInitializers, credentialHandlerProperties, credentialHandlers, false, supportsCredential, false);
        this.ldapURL = url;
        this.connectionProperties = connectionProperties;
        this.bindDN = bindDN;
        this.bindCredential = bindCredential;
        this.activeDirectory = activeDirectory;
        this.baseDN = baseDN;
        this.mappingConfig = mappingConfig;
        this.pagination = pagination;
        this.uniqueIdentifierAttributeName = uniqueIdentifierAttributeName != null ? uniqueIdentifierAttributeName : (activeDirectory ? "objectGUID" : "entryUUID");
    }

    public String getLdapURL() {
        return this.ldapURL;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public String getBindCredential() {
        return this.bindCredential;
    }

    public boolean isActiveDirectory() {
        return this.activeDirectory;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public Map<Class<? extends AttributedType>, LDAPMappingConfiguration> getMappingConfig() {
        return this.mappingConfig;
    }

    public Class<? extends AttributedType> getSupportedTypeByBaseDN(String entryDN, List<String> objectClasses) {
        String entryBaseDN = entryDN.substring(entryDN.indexOf(",") + 1);
        for (LDAPMappingConfiguration mappingConfig : this.mappingConfig.values()) {
            if (mappingConfig.getBaseDN() == null || Relationship.class.isAssignableFrom(mappingConfig.getMappedClass())) continue;
            if (mappingConfig.getBaseDN().equalsIgnoreCase(entryDN) || mappingConfig.getParentMapping().values().contains(entryDN)) {
                return mappingConfig.getMappedClass();
            }
            if (!mappingConfig.getBaseDN().equalsIgnoreCase(entryBaseDN) && !mappingConfig.getParentMapping().values().contains(entryBaseDN)) continue;
            return mappingConfig.getMappedClass();
        }
        for (LDAPMappingConfiguration mappingConfig : this.mappingConfig.values()) {
            if (Relationship.class.isAssignableFrom(mappingConfig.getMappedClass())) continue;
            for (String objectClass : objectClasses) {
                if (!mappingConfig.getObjectClasses().contains(objectClass)) continue;
                return mappingConfig.getMappedClass();
            }
        }
        throw new IdentityManagementException("No type found with Base DN [" + entryDN + "] or objectClasses [" + objectClasses + ".");
    }

    public LDAPMappingConfiguration getMappingConfig(Class<? extends AttributedType> attributedType) {
        for (LDAPMappingConfiguration mappingConfig : this.mappingConfig.values()) {
            if (!attributedType.equals(mappingConfig.getMappedClass())) continue;
            return mappingConfig;
        }
        return null;
    }

    public List<LDAPMappingConfiguration> getRelationshipConfigs() {
        ArrayList<LDAPMappingConfiguration> result = new ArrayList<LDAPMappingConfiguration>();
        for (LDAPMappingConfiguration mappingConfig : this.mappingConfig.values()) {
            if (mappingConfig.getRelatedAttributedType() == null) continue;
            result.add(mappingConfig);
        }
        return result;
    }

    @Override
    public boolean supportsPartition() {
        return false;
    }

    @Override
    public boolean supportsPermissions() {
        return false;
    }

    public String getUniqueIdentifierAttributeName() {
        return this.uniqueIdentifierAttributeName;
    }

    public boolean isPagination() {
        return this.pagination;
    }
}

