/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.PasswordUtil;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;

public final class FileSystemSecurityRealm
implements ModifiableSecurityRealm {
    static final String ELYTRON_1_0 = "urn:elytron:1.0";
    private final Path root;
    private final NameRewriter nameRewriter;
    private final int levels;

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels) {
        this.root = root;
        this.nameRewriter = nameRewriter;
        this.levels = levels;
    }

    public FileSystemSecurityRealm(Path root, int levels) {
        this.root = root;
        this.levels = levels;
        this.nameRewriter = NameRewriter.IDENTITY_REWRITER;
    }

    public FileSystemSecurityRealm(Path root) {
        this.root = root;
        this.levels = 2;
        this.nameRewriter = NameRewriter.IDENTITY_REWRITER;
    }

    private Path pathFor(String name) {
        assert (name.codePointCount(0, name.length()) > 0);
        int levels = this.levels;
        Path path = this.root;
        int idx = 0;
        for (int level = 0; level < levels; ++level) {
            int newIdx = name.offsetByCodePoints(idx, 1);
            path = path.resolve(name.substring(idx, newIdx));
            idx = newIdx;
            if (idx == name.length()) break;
        }
        return path.resolve(name + ".xml");
    }

    @Override
    public ModifiableRealmIdentity createRealmIdentity(String name) {
        if (name.isEmpty()) {
            throw ElytronMessages.log.invalidEmptyName();
        }
        String finalName = this.nameRewriter.rewriteName(name);
        if (finalName == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new Identity(finalName, this.pathFor(finalName));
    }

    @Override
    public Iterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        return this.subIterator(this.root, this.levels);
    }

    private Iterator<ModifiableRealmIdentity> subIterator(Path root, final int levels) {
        Iterator<Path> iterator;
        if (levels == 0) {
            Iterator<Path> iterator2;
            try {
                iterator2 = Files.newDirectoryStream(root, "*.xml").iterator();
            }
            catch (IOException e) {
                return Collections.emptyIterator();
            }
            return new Iterator<ModifiableRealmIdentity>(){

                @Override
                public boolean hasNext() {
                    return iterator2.hasNext();
                }

                @Override
                public ModifiableRealmIdentity next() {
                    Path path = (Path)iterator2.next();
                    String fileName = path.getFileName().toString();
                    return FileSystemSecurityRealm.this.createRealmIdentity(fileName.substring(0, fileName.length() - 4));
                }
            };
        }
        try {
            iterator = Files.newDirectoryStream(root, entry -> {
                String fileName = entry.getFileName().toString();
                return fileName.length() == 1 && !fileName.equals(".") && Files.isDirectory(entry, new LinkOption[0]);
            }).iterator();
        }
        catch (IOException e) {
            return Collections.emptyIterator();
        }
        return new Iterator<ModifiableRealmIdentity>(){
            private Iterator<ModifiableRealmIdentity> subIterator;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.subIterator == null) {
                        if (!iterator.hasNext()) {
                            return false;
                        }
                        Path path = (Path)iterator.next();
                        this.subIterator = FileSystemSecurityRealm.this.subIterator(path, levels - 1);
                        continue;
                    }
                    if (this.subIterator.hasNext()) {
                        return true;
                    }
                    this.subIterator = null;
                }
            }

            @Override
            public ModifiableRealmIdentity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.subIterator.next();
            }
        };
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
        return CredentialSupport.UNKNOWN;
    }

    static class AutoCloseableXMLStreamWriterHolder
    implements AutoCloseable {
        private final XMLStreamWriter xmlStreamWriter;

        AutoCloseableXMLStreamWriterHolder(XMLStreamWriter xmlStreamWriter) {
            this.xmlStreamWriter = xmlStreamWriter;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamWriter.close();
        }

        public XMLStreamWriter getXmlStreamWriter() {
            return this.xmlStreamWriter;
        }
    }

    static class AutoCloseableXMLStreamReaderHolder
    implements AutoCloseable {
        private final XMLStreamReader xmlStreamReader;

        AutoCloseableXMLStreamReaderHolder(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamReader.close();
        }

        public XMLStreamReader getXmlStreamReader() {
            return this.xmlStreamReader;
        }
    }

    final class LoadedIdentity {
        private final String name;
        private final List<Object> credentials;
        private final Attributes attributes;

        LoadedIdentity(String name, List<Object> credentials, Attributes attributes) {
            this.name = name;
            this.credentials = credentials;
            this.attributes = attributes;
        }

        public String getName() {
            return this.name;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        List<Object> getCredentials() {
            return this.credentials;
        }
    }

    class Identity
    implements ModifiableRealmIdentity {
        private final String name;
        private final Path path;

        Identity(String name, Path path) {
            this.name = name;
            this.path = path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
            List<Object> credentials = this.loadCredentials();
            for (Object credential : credentials) {
                if (!credentialType.isInstance(credential)) continue;
                return CredentialSupport.FULLY_SUPPORTED;
            }
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            List<Object> credentials = this.loadCredentials();
            for (Object credential : credentials) {
                if (!credentialType.isInstance(credential)) continue;
                return credentialType.cast(credential);
            }
            return null;
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            if (credential instanceof ClearPassword) {
                ClearPassword clearPassword = (ClearPassword)credential;
                List<Object> credentials = this.loadCredentials();
                for (Object ours : credentials) {
                    if (!(ours instanceof Password)) continue;
                    try {
                        Password password = (Password)ours;
                        String algorithm = password.getAlgorithm();
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm);
                        return passwordFactory.verify(password, clearPassword.getPassword());
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                    }
                }
            }
            return false;
        }

        private List<Object> loadCredentials() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            return loadedIdentity == null ? Collections.emptyList() : loadedIdentity.getCredentials();
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return Files.exists(this.path, new LinkOption[0]);
        }

        @Override
        public void delete() throws RealmUnavailableException {
            try {
                Files.delete(this.path);
            }
            catch (NoSuchFileException e) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.getName());
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmDeleteFailed(this.getName(), e);
            }
        }

        private String tempSuffix() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            char[] array = new char[12];
            for (int i = 0; i < array.length; ++i) {
                int idx = random.nextInt(36);
                array[i] = idx < 26 ? (char)(65 + idx) : (char)(48 + idx - 26);
            }
            return new String(array);
        }

        private Path tempPath() {
            return this.path.getParent().resolve(this.path.getFileName().toString() + '.' + this.tempSuffix());
        }

        @Override
        public void create() throws RealmUnavailableException {
            Path tempPath;
            while (true) {
                tempPath = this.tempPath();
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(tempPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.DSYNC));){
                    try (AutoCloseableXMLStreamWriterHolder holder = new AutoCloseableXMLStreamWriterHolder(xmlOutputFactory.createXMLStreamWriter(outputStream));){
                        XMLStreamWriter streamWriter = holder.getXmlStreamWriter();
                        streamWriter.writeStartDocument();
                        streamWriter.writeCharacters("\n");
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "identity");
                        streamWriter.writeEndElement();
                        streamWriter.writeEndDocument();
                    }
                    catch (XMLStreamException e) {
                        throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.getName(), e);
                    }
                }
                catch (FileAlreadyExistsException ignored) {
                    continue;
                }
                catch (IOException e) {
                    throw ElytronMessages.log.fileSystemRealmFailedToOpen(tempPath, this.getName(), e);
                }
                break;
            }
            try {
                Files.createLink(this.path, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                try {
                    Files.delete(tempPath);
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                }
                throw ElytronMessages.log.fileSystemRealmAlreadyExists(this.getName(), e);
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.getName(), e);
            }
            try {
                Files.delete(tempPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void setCredentials(List<Object> credentials) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentials", credentials);
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.getName(), credentials, loadedIdentity.getAttributes());
            this.replaceIdentity(newIdentity);
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"attributes", (Object)attributes);
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.getName(), loadedIdentity.getCredentials(), attributes);
            this.replaceIdentity(newIdentity);
        }

        /*
         * Exception decompiling
         */
        private void replaceIdentity(LoadedIdentity newIdentity) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [36[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void writeIdentity(XMLStreamWriter streamWriter, LoadedIdentity newIdentity) throws XMLStreamException, InvalidKeySpecException, CertificateEncodingException {
            Iterator<Attributes.Entry> entryIter;
            streamWriter.writeStartDocument();
            streamWriter.writeCharacters("\n");
            streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "identity");
            Iterator<Object> credIter = newIdentity.getCredentials().iterator();
            if (credIter.hasNext()) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "credentials");
                do {
                    streamWriter.writeCharacters("\n        ");
                    Object credential = credIter.next();
                    if (credential instanceof Password) {
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "password");
                        streamWriter.writeCharacters(PasswordUtil.getCryptString((Password)credential));
                        streamWriter.writeEndElement();
                        continue;
                    }
                    if (credential instanceof PublicKey) {
                        PublicKey publicKey = (PublicKey)credential;
                        String algorithm = publicKey.getAlgorithm();
                        String format = publicKey.getFormat();
                        byte[] encoded = publicKey.getEncoded();
                        CodePointIterator iterator = ByteIterator.ofBytes(encoded).base64Encode();
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "public-key");
                        streamWriter.writeAttribute("algorithm", algorithm);
                        streamWriter.writeAttribute("format", format);
                        while (iterator.hasNext()) {
                            streamWriter.writeCharacters("\n            ");
                            streamWriter.writeCharacters(iterator.limitedTo(64).drainToString());
                        }
                        streamWriter.writeCharacters("\n        ");
                        streamWriter.writeEndElement();
                        continue;
                    }
                    if (!(credential instanceof X509Certificate)) continue;
                    X509Certificate certificate = (X509Certificate)credential;
                    byte[] encoded = certificate.getEncoded();
                    CodePointIterator iterator = ByteIterator.ofBytes(encoded).base64Encode();
                    streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "certificate");
                    streamWriter.writeAttribute("algorithm", "X.509");
                    while (iterator.hasNext()) {
                        streamWriter.writeCharacters("\n            ");
                        streamWriter.writeCharacters(iterator.limitedTo(64).drainToString());
                    }
                    streamWriter.writeCharacters("\n        ");
                    streamWriter.writeEndElement();
                } while (credIter.hasNext());
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
            }
            if ((entryIter = newIdentity.getAttributes().entries().iterator()).hasNext()) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "attributes");
                do {
                    Attributes.Entry entry = entryIter.next();
                    for (String value : entry) {
                        streamWriter.writeCharacters("\n        ");
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "attribute");
                        streamWriter.writeAttribute("name", entry.getKey());
                        streamWriter.writeAttribute("value", value);
                        streamWriter.writeEndElement();
                    }
                } while (entryIter.hasNext());
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
            streamWriter.writeEndDocument();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            return loadedIdentity == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(loadedIdentity.getAttributes());
        }

        /*
         * Exception decompiling
         */
        private LoadedIdentity loadIdentity(boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private LoadedIdentity parseIdentity(XMLStreamReader streamReader, boolean skipCredentials, boolean skipRoles) throws RealmUnavailableException, XMLStreamException {
            int tag = streamReader.nextTag();
            if (tag != 1 || !FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI()) || !"identity".equals(streamReader.getLocalName())) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            return this.parseIdentityContents(streamReader, skipCredentials, skipRoles);
        }

        private LoadedIdentity parseIdentityContents(XMLStreamReader streamReader, boolean skipCredentials, boolean skipRoles) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            List<Object> credentials = Collections.emptyList();
            Attributes attributes = Attributes.EMPTY;
            boolean gotCredentials = false;
            boolean gotRoles = false;
            int tag;
            while ((tag = streamReader.nextTag()) != 2) {
                assert (tag == 1);
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if (!gotCredentials && "credentials".equals(streamReader.getLocalName())) {
                    gotCredentials = true;
                    if (skipCredentials) {
                        this.consumeContent(streamReader);
                        continue;
                    }
                    credentials = this.parseCredentials(streamReader);
                    continue;
                }
                if (gotRoles || !"attributes".equals(streamReader.getLocalName())) continue;
                gotRoles = true;
                if (skipRoles) {
                    this.consumeContent(streamReader);
                    continue;
                }
                attributes = this.parseAttributes(streamReader);
            }
            return new LoadedIdentity(this.name, credentials, attributes);
        }

        private List<Object> parseCredentials(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            int tag = streamReader.nextTag();
            if (tag == 2) {
                return Collections.emptyList();
            }
            ArrayList<Object> credentials = new ArrayList<Object>();
            do {
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if ("password".equals(streamReader.getLocalName())) {
                    credentials.add(this.parsePassword(streamReader));
                    continue;
                }
                if ("private-key".equals(streamReader.getLocalName())) {
                    credentials.add(this.parsePrivateKey(streamReader));
                    continue;
                }
                if ("certificate".equals(streamReader.getLocalName())) {
                    credentials.add(this.parseCertificate(streamReader));
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            } while (streamReader.nextTag() == 1);
            return credentials;
        }

        private <C> C parseCredential(XMLStreamReader streamReader, CredentialParseFunction<C> function) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            String algorithm = null;
            String format = null;
            for (int i = 0; i < attributeCount; ++i) {
                if (streamReader.getAttributeNamespace(i) != null) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                String localName = streamReader.getAttributeLocalName(i);
                if ("algorithm".equals(localName)) {
                    algorithm = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("format".equals(localName)) {
                    format = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            String text = streamReader.getElementText().trim();
            C cred = function.parseCredential(algorithm, format, text);
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            return cred;
        }

        private X509Certificate parseCertificate(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            return this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    algorithm = "X.509";
                }
                if (format == null) {
                    format = "X.509";
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(algorithm);
                    return (X509Certificate)certificateFactory.generateCertificate(CodePointIterator.ofString(text).base64Decode().asInputStream());
                }
                catch (ClassCastException | CertificateException e) {
                    throw ElytronMessages.log.fileSystemRealmCertificateReadError(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
            });
        }

        private PrivateKey parsePrivateKey(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            return this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    throw ElytronMessages.log.fileSystemRealmMissingAttribute("algorithm", this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                try {
                    if (format != null && !format.equals("X.509")) {
                        throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                    }
                    X509EncodedKeySpec keySpec = new X509EncodedKeySpec(CodePointIterator.ofString(text).base64Decode().drain());
                    return KeyFactory.getInstance(algorithm).generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                catch (NoSuchAlgorithmException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyAlgorithm(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
            });
        }

        private Password parsePassword(XMLStreamReader streamReader) throws XMLStreamException, RealmUnavailableException {
            return this.parseCredential(streamReader, (algorithm, format, text) -> {
                try {
                    if ("crypt".equals(format)) {
                        return PasswordUtil.parseCryptString(text);
                    }
                    throw ElytronMessages.log.fileSystemRealmInvalidPasswordFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
            });
        }

        private Attributes parseAttributes(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            int tag = streamReader.nextTag();
            if (tag == 2) {
                return Attributes.EMPTY;
            }
            MapAttributes attributes = new MapAttributes();
            do {
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if (!"attribute".equals(streamReader.getLocalName())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                this.parseAttribute(streamReader, attributes);
            } while (streamReader.nextTag() == 1);
            return attributes;
        }

        private void parseAttribute(XMLStreamReader streamReader, Attributes attributes) throws XMLStreamException, RealmUnavailableException {
            String name = null;
            String value = null;
            int attributeCount = streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                if (streamReader.getAttributeNamespace(i) != null) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if ("name".equals(streamReader.getAttributeLocalName(i))) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("value".equals(streamReader.getAttributeLocalName(i))) {
                    value = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            if (name == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("name", this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            if (value == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("value", this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            attributes.addLast(name, value);
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
        }

        private void consumeContent(XMLStreamReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        this.consumeContent(reader);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }
    }

    @FunctionalInterface
    static interface CredentialParseFunction<C> {
        public C parseCredential(String var1, String var2, String var3) throws RealmUnavailableException, XMLStreamException;
    }
}

