/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gs2;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.gs2.Gs2SaslClient;
import org.wildfly.security.sasl.gs2.Gs2Util;

public final class Gs2SaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        String[] supportedMechanisms;
        String name = null;
        boolean plus = false;
        ChannelBindingCallback callback = new ChannelBindingCallback();
        try {
            cbh.handle(new Callback[]{callback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.log.saslFailedToDetermineChannelBindingStatus(e);
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        GSSManager gssManager = GSSManager.getInstance();
        try {
            supportedMechanisms = Gs2Util.getSupportedSaslNamesForMechanisms(gssManager.getMechs());
        }
        catch (GSSException e) {
            throw ElytronMessages.log.saslGettingSupportedMechanismsFailed(e);
        }
        String bindingType = callback.getBindingType();
        byte[] bindingData = callback.getBindingData();
        boolean bindingOk = bindingType != null && bindingData != null;
        boolean bindingRequired = "true".equals(props.get("wildfly.sasl.channel-binding-required"));
        for (String mechanism : mechanisms) {
            if (!Gs2Util.isIncluded(mechanism, supportedMechanisms)) continue;
            if (mechanism.endsWith("-PLUS")) {
                if (!bindingOk) continue;
                plus = true;
            }
            if (bindingRequired && !plus) continue;
            name = mechanism;
            break;
        }
        if (name == null) {
            return null;
        }
        Gs2SaslClient client = new Gs2SaslClient(name, protocol, serverName, cbh, authorizationId, props, gssManager, plus, bindingType, bindingData);
        client.init();
        return client;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] names;
        try {
            names = Gs2Util.getSupportedSaslNamesForMechanisms(GSSManager.getInstance().getMechs());
        }
        catch (GSSException e) {
            return WildFlySasl.NO_NAMES;
        }
        if (!"true".equals(props.get("wildfly.sasl.mechanism-query-all")) && "true".equals(props.get("wildfly.sasl.channel-binding-required"))) {
            return Gs2Util.getPlusMechanisms(names);
        }
        return names;
    }
}

