/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.security.util._private.Arrays2;

public interface SNIServerSSLContextSelector {
    public static final SNIServerSSLContextSelector NULL_SELECTOR = SNIServerSSLContextSelector.constantSelector(null);

    public SSLContext selectContext(SNIServerName var1);

    public static SNIServerSSLContextSelector aggregate(SNIServerSSLContextSelector selector1, SNIServerSSLContextSelector selector2) {
        return name -> {
            SSLContext sslContext = null;
            if (selector1 != null) {
                sslContext = selector1.selectContext(name);
            }
            if (sslContext == null && selector2 != null) {
                sslContext = selector2.selectContext(name);
            }
            return sslContext;
        };
    }

    public static SNIServerSSLContextSelector aggregate(SNIServerSSLContextSelector ... selectors) {
        Assert.checkNotNullParam((String)"selectors", (Object)selectors);
        SNIServerSSLContextSelector[] clone = (SNIServerSSLContextSelector[])Arrays2.compactNulls((Object[])selectors.clone());
        if (clone.length == 0) {
            return NULL_SELECTOR;
        }
        if (clone.length == 1) {
            return clone[0];
        }
        if (clone.length == 2) {
            return SNIServerSSLContextSelector.aggregate(clone[0], clone[1]);
        }
        return name -> {
            for (SNIServerSSLContextSelector selector : clone) {
                SSLContext sslContext = selector.selectContext(name);
                if (sslContext == null) continue;
                return sslContext;
            }
            return null;
        };
    }

    public static SNIServerSSLContextSelector matcherSelector(SNIMatcher matcher, SSLContext context) {
        return name -> name.getType() == matcher.getType() && matcher.matches(name) ? context : null;
    }

    public static SNIServerSSLContextSelector constantSelector(SSLContext context) {
        return name -> context;
    }
}

