/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetric;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetricExecutor;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceRegistrationHandler;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ChannelResourceDefinition
extends SimpleResourceDefinition
implements Registration {
    public static final PathElement WILDCARD_PATH = ChannelResourceDefinition.pathElement("*");
    final boolean allowRuntimeOnlyRegistration;

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"channel", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
    }

    ChannelResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH));
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class);
        ChannelServiceHandler handler = new ChannelServiceHandler();
        new AddStepHandler((AddStepHandlerDescriptor)descriptor, handler){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                if (ChannelResourceDefinition.this.allowRuntimeOnlyRegistration && context.getRunningMode() == RunningMode.NORMAL) {
                    String name = context.getCurrentAddressValue();
                    String stack = ModelNodes.asString((ModelNode)Attribute.STACK.getDefinition().resolveModelAttribute(context, resource.getModel()));
                    PathAddress address = context.getCurrentAddress();
                    PathAddress subsystemAddress = address.subAddress(0, address.size() - 1);
                    PathAddress stackAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement(stack != null ? stack : JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK.getDefinition().resolveModelAttribute(context, context.readResourceFromRoot(subsystemAddress, false).getModel()).asString())});
                    context.addStep((OperationStepHandler)new ProtocolResourceRegistrationHandler(name, stackAddress), OperationContext.Stage.MODEL);
                }
            }
        }.register(registration);
        new RemoveStepHandler((RemoveStepHandlerDescriptor)descriptor, handler){

            protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                if (ChannelResourceDefinition.this.allowRuntimeOnlyRegistration && context.getRunningMode() == RunningMode.NORMAL) {
                    Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                    for (Resource.ResourceEntry entry : resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        context.removeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{entry.getPathElement()}));
                    }
                    context.getResourceRegistrationForUpdate().unregisterOverrideModel(context.getCurrentAddressValue());
                }
                super.performRemove(context, operation, model);
            }
        }.register(registration);
    }

    public void registerChildren(ManagementResourceRegistration registration) {
        new ForkResourceDefinition(this.allowRuntimeOnlyRegistration).register(registration);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        new ReloadRequiredWriteAttributeHandler(Attribute.class).register(registration);
        if (this.allowRuntimeOnlyRegistration) {
            new MetricHandler((MetricExecutor)new ChannelMetricExecutor(), ChannelMetric.class).register(registration);
        }
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)this);
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        STACK("stack", ModelType.STRING, null),
        MODULE("module", ModelType.STRING, new ModelNode("org.wildfly.clustering.server"), (ParameterValidatorBuilder)new ModuleIdentifierValidatorBuilder());

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = Attribute.createBuilder(name, type, defaultValue).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validator) {
            SimpleAttributeDefinitionBuilder builder = Attribute.createBuilder(name, type, defaultValue);
            this.definition = ((SimpleAttributeDefinitionBuilder)builder.setValidator(validator.configure((AbstractAttributeDefinitionBuilder)builder).build())).build();
        }

        private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue) {
            return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

