/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Arguments;
import io.airlift.airline.Help;
import io.airlift.airline.Option;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import java.io.File;
import javax.inject.Inject;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.factory.BrokerFactory;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;

public abstract class Configurable
extends ActionAbstract {
    @Arguments(description="Broker Configuration URI, default 'xml:${ARTEMIS_INSTANCE}/etc/bootstrap.xml'")
    String configuration;
    @Option(name={"--broker"}, description="This would override the broker configuration from the bootstrap")
    String brokerConfig;
    @Inject
    public GlobalMetadata global;
    private BrokerDTO brokerDTO = null;
    private String brokerInstance;
    private String brokerHome;
    private FileConfiguration fileConfiguration;

    protected void treatError(Exception e, String group, String command) {
        ActiveMQBootstrapLogger.LOGGER.debug(e.getMessage(), e);
        System.err.println();
        System.err.println("Error:" + e.getMessage());
        System.err.println();
        this.helpGroup(group, command);
    }

    protected String getBrokerInstance() {
        if (this.brokerInstance == null) {
            this.brokerInstance = System.getProperty("artemis.instance");
            if (this.brokerInstance != null) {
                this.brokerInstance = this.brokerInstance.replace("\\", "/");
                System.setProperty("artemis.instance", this.brokerInstance);
            }
        }
        return this.brokerInstance;
    }

    protected void helpGroup(String groupName, String commandName) {
        for (CommandGroupMetadata group : this.global.getCommandGroups()) {
            if (!group.getName().equals(groupName)) continue;
            for (CommandMetadata command : group.getCommands()) {
                if (!command.getName().equals(commandName)) continue;
                Help.help((CommandMetadata)command);
            }
        }
    }

    protected String getBrokerHome() {
        if (this.brokerHome == null) {
            this.brokerHome = System.getProperty("artemis.home");
            if (this.brokerHome != null) {
                this.brokerHome = this.brokerHome.replace("\\", "/");
                System.setProperty("artemis.home", this.brokerHome);
            }
        }
        return this.brokerHome;
    }

    protected FileConfiguration getFileConfiguration() throws Exception {
        if (this.fileConfiguration == null) {
            if (this.getBrokerInstance() == null) {
                String defaultLocation = "../data";
                this.fileConfiguration = new FileConfiguration();
                this.fileConfiguration.setBindingsDirectory("../data/bindings");
                this.fileConfiguration.setJournalDirectory("../data/journal");
                this.fileConfiguration.setLargeMessagesDirectory("../data/largemessages");
                this.fileConfiguration.setPagingDirectory("../data/paging");
            } else {
                this.fileConfiguration = new FileConfiguration();
                FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
                String serverConfiguration = this.getBrokerDTO().server.configuration;
                FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(serverConfiguration);
                fileDeploymentManager.addDeployable((Deployable)this.fileConfiguration).addDeployable((Deployable)jmsConfiguration);
                fileDeploymentManager.readConfiguration();
            }
        }
        return this.fileConfiguration;
    }

    protected BrokerDTO getBrokerDTO() throws Exception {
        if (this.brokerDTO == null) {
            this.getConfiguration();
            this.brokerDTO = BrokerFactory.createBrokerConfiguration(this.configuration);
            if (this.brokerConfig != null) {
                if (!this.brokerConfig.startsWith("file:")) {
                    this.brokerConfig = "file:" + this.brokerConfig;
                }
                this.brokerDTO.server.configuration = this.brokerConfig;
            }
        }
        return this.brokerDTO;
    }

    protected String getConfiguration() {
        if (this.configuration == null) {
            File xmlFile = new File(new File(new File(this.getBrokerInstance()), "etc"), "bootstrap.xml");
            this.configuration = "xml:" + xmlFile.toURI().toString().substring("file:".length());
            this.configuration = this.configuration.replace("\\", "/");
            ActiveMQBootstrapLogger.LOGGER.usingBrokerConfig(this.configuration);
        }
        return this.configuration;
    }
}

